/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.cleanup;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.fix.CleanUpRegistry;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.cleanup.CleanUpMessages;
import org.eclipse.jdt.internal.ui.preferences.cleanup.ICleanUpTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class CleanUpModifyDialog
extends ModifyDialog {
    static String[] FALSE_TRUE = new String[]{"false", "true"};
    private Label fCountLabel;
    private ICleanUpTabPage[] fPages;

    public CleanUpModifyDialog(Shell parentShell, ProfileManager.Profile profile, ProfileManager profileManager, ProfileStore profileStore, boolean newProfile, String dialogPreferencesKey, String lastSavePathKey) {
        super(parentShell, profile, profileManager, profileStore, newProfile, dialogPreferencesKey, lastSavePathKey);
    }

    protected void addPages(Map values) {
        CleanUpRegistry.CleanUpTabPageDescriptor[] descriptors = JavaPlugin.getDefault().getCleanUpRegistry().getCleanUpTabPageDescriptors();
        this.fPages = new ICleanUpTabPage[descriptors.length];
        int i = 0;
        while (i < descriptors.length) {
            String name = descriptors[i].getName();
            ICleanUpTabPage page = descriptors[i].createTabPage();
            page.setOptionsKind(1);
            page.setModifyListener(this);
            page.setWorkingValues(values);
            this.addTabPage(name, page);
            this.fPages[i] = page;
            ++i;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = (Composite)super.createDialogArea(parent);
        this.fCountLabel = new Label(control, 0);
        this.fCountLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        this.fCountLabel.setFont(parent.getFont());
        this.updateCountLabel();
        return control;
    }

    public void updateStatus(IStatus status) {
        int count = 0;
        int i = 0;
        while (i < this.fPages.length) {
            count += this.fPages[i].getSelectedCleanUpCount();
            ++i;
        }
        if (count == 0) {
            super.updateStatus((IStatus)new Status(4, "org.eclipse.jdt.ui", CleanUpMessages.CleanUpModifyDialog_SelectOne_Error));
        } else {
            super.updateStatus(status);
        }
    }

    public void valuesModified() {
        super.valuesModified();
        this.updateCountLabel();
    }

    private void updateCountLabel() {
        int size = 0;
        int count = 0;
        int i = 0;
        while (i < this.fPages.length) {
            size += this.fPages[i].getCleanUpCount();
            count += this.fPages[i].getSelectedCleanUpCount();
            ++i;
        }
        this.fCountLabel.setText(Messages.format(CleanUpMessages.CleanUpModifyDialog_XofYSelected_Label, new Object[]{new Integer(count), new Integer(size)}));
    }
}

