/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.jdt.internal.corext.refactoring.tagging.IDelegateUpdating;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class DelegateUIHelper {
    public static final String DELEGATE_UPDATING = "delegateUpdating";
    public static final String DELEGATE_DEPRECATION = "delegateDeprecation";
    static /* synthetic */ Class class$0;

    public static Button generateDeprecateDelegateCheckbox(Composite parent, Refactoring refactoring) {
        IDelegateUpdating updating;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.internal.corext.refactoring.tagging.IDelegateUpdating");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((updating = (IDelegateUpdating)refactoring.getAdapter((Class)clazz)) == null || !updating.canEnableDelegateUpdating()) {
            return null;
        }
        final Button button = DelegateUIHelper.createCheckbox(parent, DelegateUIHelper.getDeprecateDelegateCheckBoxTitle(), DelegateUIHelper.loadDeprecateDelegateSetting(updating));
        updating.setDeprecateDelegates(button.getSelection());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                updating.setDeprecateDelegates(button.getSelection());
            }
        });
        return button;
    }

    public static Button generateLeaveDelegateCheckbox(Composite parent, Refactoring refactoring, boolean plural) {
        IDelegateUpdating updating;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.internal.corext.refactoring.tagging.IDelegateUpdating");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((updating = (IDelegateUpdating)refactoring.getAdapter((Class)clazz)) == null || !updating.canEnableDelegateUpdating()) {
            return null;
        }
        final Button button = DelegateUIHelper.createCheckbox(parent, updating.getDelegateUpdatingTitle(plural), DelegateUIHelper.loadLeaveDelegateSetting(updating));
        updating.setDelegateUpdating(button.getSelection());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                updating.setDelegateUpdating(button.getSelection());
            }
        });
        return button;
    }

    public static void saveLeaveDelegateSetting(Button button) {
        DelegateUIHelper.saveBooleanSetting(DELEGATE_UPDATING, button);
    }

    public static void saveDeprecateDelegateSetting(Button button) {
        DelegateUIHelper.saveBooleanSetting(DELEGATE_DEPRECATION, button);
    }

    public static boolean loadLeaveDelegateSetting(IDelegateUpdating refactoring) {
        return DelegateUIHelper.getBooleanSetting(DELEGATE_UPDATING, refactoring.getDelegateUpdating());
    }

    public static boolean loadDeprecateDelegateSetting(IDelegateUpdating refactoring) {
        return DelegateUIHelper.getBooleanSetting(DELEGATE_DEPRECATION, refactoring.getDeprecateDelegates());
    }

    public static String getDeprecateDelegateCheckBoxTitle() {
        return RefactoringMessages.DelegateCreator_deprecate_delegates;
    }

    private DelegateUIHelper() {
    }

    private static Button createCheckbox(Composite parent, String title, boolean value) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(title);
        checkBox.setSelection(value);
        return checkBox;
    }

    private static boolean getBooleanSetting(String key, boolean defaultValue) {
        String update = JavaPlugin.getDefault().getDialogSettings().get(key);
        if (update != null) {
            return Boolean.valueOf(update);
        }
        return defaultValue;
    }

    private static void saveBooleanSetting(String key, Button button) {
        if (button != null && !button.isDisposed() && button.getEnabled()) {
            JavaPlugin.getDefault().getDialogSettings().put(key, button.getSelection());
        }
    }
}

