/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import org.eclipse.jdt.internal.ui.viewsupport.ColoredViewersManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.custom.StyleRange;

public class ColoringLabelProvider
extends DecoratingStyledCellLabelProvider
implements ILabelProvider {
    public static final StyledString.Styler HIGHLIGHT_STYLE = StyledString.createColorRegistryStyler(null, (String)"org.eclipse.jdt.ui.ColoredLabels.match_highlight");
    public static final StyledString.Styler HIGHLIGHT_WRITE_STYLE = StyledString.createColorRegistryStyler(null, (String)"org.eclipse.jdt.ui.ColoredLabels.writeaccess_highlight");

    public ColoringLabelProvider(DelegatingStyledCellLabelProvider.IStyledLabelProvider labelProvider) {
        this(labelProvider, null, null);
    }

    public ColoringLabelProvider(DelegatingStyledCellLabelProvider.IStyledLabelProvider labelProvider, ILabelDecorator decorator, IDecorationContext decorationContext) {
        super(labelProvider, decorator, decorationContext);
    }

    public void initialize(ColumnViewer viewer, ViewerColumn column) {
        ColoredViewersManager.install(this);
        this.setOwnerDrawEnabled(ColoredViewersManager.showColoredLabels());
        super.initialize(viewer, column);
    }

    public void dispose() {
        super.dispose();
        ColoredViewersManager.uninstall(this);
    }

    public void refresh() {
        ColumnViewer viewer = this.getViewer();
        if (viewer == null) {
            return;
        }
        boolean showColoredLabels = ColoredViewersManager.showColoredLabels();
        if (showColoredLabels != this.isOwnerDrawEnabled()) {
            this.setOwnerDrawEnabled(showColoredLabels);
            viewer.refresh();
        } else if (showColoredLabels) {
            viewer.refresh();
        }
    }

    protected StyleRange prepareStyleRange(StyleRange styleRange, boolean applyColors) {
        if (!applyColors && styleRange.background != null) {
            styleRange = super.prepareStyleRange(styleRange, applyColors);
            styleRange.borderStyle = 4;
            return styleRange;
        }
        return super.prepareStyleRange(styleRange, applyColors);
    }

    public String getText(Object element) {
        return this.getStyledText(element).getString();
    }

    public static StyledString decorateStyledString(StyledString string, String decorated, StyledString.Styler color) {
        String label = string.getString();
        int originalStart = decorated.indexOf(label);
        if (originalStart == -1) {
            return new StyledString(decorated);
        }
        if (originalStart > 0) {
            StyledString newString = new StyledString(decorated.substring(0, originalStart), color);
            newString.append(string);
            string = newString;
        }
        if (decorated.length() > originalStart + label.length()) {
            return string.append(decorated.substring(originalStart + label.length()), color);
        }
        return string;
    }
}

