/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jdt.ui.actions.FindAction;
import org.eclipse.jdt.ui.actions.FindReadReferencesAction;
import org.eclipse.jdt.ui.actions.FindReadReferencesInHierarchyAction;
import org.eclipse.jdt.ui.actions.FindReadReferencesInProjectAction;
import org.eclipse.jdt.ui.actions.FindReadReferencesInWorkingSetAction;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jdt.ui.actions.WorkingSetFindAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionGroup;

public class ReadReferencesSearchGroup
extends ActionGroup {
    private static final String MENU_TEXT = SearchMessages.group_readReferences;
    private IWorkbenchSite fSite;
    private JavaEditor fEditor;
    private IActionBars fActionBars;
    private String fGroupId;
    private FindReadReferencesAction fFindReadReferencesAction;
    private FindReadReferencesInProjectAction fFindReadReferencesInProjectAction;
    private FindReadReferencesInHierarchyAction fFindReadReferencesInHierarchyAction;
    private FindReadReferencesInWorkingSetAction fFindReadReferencesInWorkingSetAction;

    public ReadReferencesSearchGroup(IWorkbenchSite site) {
        this(site, null);
    }

    public ReadReferencesSearchGroup(IWorkbenchSite site, ISelectionProvider specialSelectionProvider) {
        this.fSite = site;
        this.fGroupId = "group.search";
        this.fFindReadReferencesAction = new FindReadReferencesAction(site);
        this.fFindReadReferencesAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.write.access.in.workspace");
        this.fFindReadReferencesInProjectAction = new FindReadReferencesInProjectAction(site);
        this.fFindReadReferencesInProjectAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.read.access.in.project");
        this.fFindReadReferencesInHierarchyAction = new FindReadReferencesInHierarchyAction(site);
        this.fFindReadReferencesInHierarchyAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.write.access.in.hierarchy");
        this.fFindReadReferencesInWorkingSetAction = new FindReadReferencesInWorkingSetAction(site);
        this.fFindReadReferencesInWorkingSetAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.write.access.in.working.set");
        ISelectionProvider provider = specialSelectionProvider == null ? this.fSite.getSelectionProvider() : specialSelectionProvider;
        ISelection selection = provider.getSelection();
        this.registerAction(this.fFindReadReferencesAction, provider, selection, specialSelectionProvider);
        this.registerAction(this.fFindReadReferencesInProjectAction, provider, selection, specialSelectionProvider);
        this.registerAction(this.fFindReadReferencesInHierarchyAction, provider, selection, specialSelectionProvider);
        this.registerAction(this.fFindReadReferencesInWorkingSetAction, provider, selection, specialSelectionProvider);
    }

    public ReadReferencesSearchGroup(JavaEditor editor) {
        this.fEditor = editor;
        this.fSite = this.fEditor.getSite();
        this.fGroupId = "group.find";
        this.fFindReadReferencesAction = new FindReadReferencesAction(this.fEditor);
        this.fFindReadReferencesAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.write.access.in.workspace");
        this.fEditor.setAction("SearchReadAccessInWorkspace", (IAction)this.fFindReadReferencesAction);
        this.fFindReadReferencesInProjectAction = new FindReadReferencesInProjectAction(this.fEditor);
        this.fFindReadReferencesInProjectAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.read.access.in.project");
        this.fEditor.setAction("SearchReadAccessInProject", (IAction)this.fFindReadReferencesInProjectAction);
        this.fFindReadReferencesInHierarchyAction = new FindReadReferencesInHierarchyAction(this.fEditor);
        this.fFindReadReferencesInHierarchyAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.write.access.in.hierarchy");
        this.fEditor.setAction("SearchReadAccessInHierarchy", (IAction)this.fFindReadReferencesInHierarchyAction);
        this.fFindReadReferencesInWorkingSetAction = new FindReadReferencesInWorkingSetAction(this.fEditor);
        this.fFindReadReferencesInWorkingSetAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.write.access.in.working.set");
        this.fEditor.setAction("SearchReadAccessInWorkingSet", (IAction)this.fFindReadReferencesInWorkingSetAction);
    }

    private void registerAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection, ISelectionProvider specialSelectionProvider) {
        action.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)action);
        if (specialSelectionProvider != null) {
            action.setSpecialSelectionProvider(specialSelectionProvider);
        }
    }

    private void addAction(IAction action, IMenuManager manager) {
        if (action.isEnabled()) {
            manager.add(action);
        }
    }

    private void addWorkingSetAction(IWorkingSet[] workingSets, IMenuManager manager) {
        WorkingSetFindAction action = this.fEditor != null ? new WorkingSetFindAction(this.fEditor, (FindAction)new FindReadReferencesInWorkingSetAction(this.fEditor, workingSets), SearchUtil.toString(workingSets)) : new WorkingSetFindAction(this.fSite, (FindAction)new FindReadReferencesInWorkingSetAction(this.fSite, workingSets), SearchUtil.toString(workingSets));
        action.update(this.getContext().getSelection());
        this.addAction((IAction)action, manager);
    }

    public void fillContextMenu(IMenuManager manager) {
        MenuManager javaSearchMM = new MenuManager(MENU_TEXT, "group.search");
        this.addAction((IAction)this.fFindReadReferencesAction, (IMenuManager)javaSearchMM);
        this.addAction((IAction)this.fFindReadReferencesInProjectAction, (IMenuManager)javaSearchMM);
        this.addAction((IAction)this.fFindReadReferencesInHierarchyAction, (IMenuManager)javaSearchMM);
        javaSearchMM.add((IContributionItem)new Separator());
        Iterator iter = SearchUtil.getLRUWorkingSets().sortedIterator();
        while (iter.hasNext()) {
            this.addWorkingSetAction((IWorkingSet[])iter.next(), (IMenuManager)javaSearchMM);
        }
        this.addAction((IAction)this.fFindReadReferencesInWorkingSetAction, (IMenuManager)javaSearchMM);
        if (!javaSearchMM.isEmpty()) {
            manager.appendToGroup(this.fGroupId, (IContributionItem)javaSearchMM);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        Assert.isNotNull((Object)actionBars);
        super.fillActionBars(actionBars);
        this.fActionBars = actionBars;
        this.updateGlobalActionHandlers();
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        if (provider != null) {
            this.disposeAction(this.fFindReadReferencesAction, provider);
            this.disposeAction(this.fFindReadReferencesInProjectAction, provider);
            this.disposeAction(this.fFindReadReferencesInHierarchyAction, provider);
            this.disposeAction(this.fFindReadReferencesInWorkingSetAction, provider);
        }
        this.fFindReadReferencesAction = null;
        this.fFindReadReferencesInProjectAction = null;
        this.fFindReadReferencesInHierarchyAction = null;
        this.fFindReadReferencesInWorkingSetAction = null;
        this.updateGlobalActionHandlers();
        super.dispose();
    }

    private void updateGlobalActionHandlers() {
        if (this.fActionBars != null) {
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ReadAccessInWorkspace", (IAction)this.fFindReadReferencesAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ReadAccessInProject", (IAction)this.fFindReadReferencesInProjectAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ReadAccessInHierarchy", (IAction)this.fFindReadReferencesInHierarchyAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ReadAccessInWorkingSet", (IAction)this.fFindReadReferencesInWorkingSetAction);
        }
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }
}

