/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - initial API and implementation
 *******************************************************************************/

#include "swt.h"
#include "com_stats.h"

#ifdef NATIVE_STATS

int COM_nativeFunctionCount = 157;
int COM_nativeFunctionCallCount[157];
char * COM_nativeFunctionNames[] = {
	"AccessibleObjectFromWindow",
	"CAUUID_1sizeof",
	"CLSIDFromProgID",
	"CLSIDFromString",
	"CONTROLINFO_1sizeof",
	"COSERVERINFO_1sizeof",
	"CoCreateInstance",
	"CoFreeUnusedLibraries",
	"CoGetClassObject",
	"CoLockObjectExternal",
	"CoTaskMemAlloc",
	"CoTaskMemFree",
	"CreateStdAccessibleObject",
	"DISPPARAMS_1sizeof",
	"DVTARGETDEVICE_1sizeof",
	"DoDragDrop",
	"ELEMDESC_1sizeof",
	"EXCEPINFO_1sizeof",
	"FORMATETC_1sizeof",
	"FUNCDESC_1sizeof",
	"GUID_1sizeof",
	"GetClassFile",
	"IIDFromString",
	"IsEqualGUID",
	"LICINFO_1sizeof",
	"LresultFromObject",
	"MoveMemory__JLorg_eclipse_swt_internal_ole_win32_FORMATETC_2I",
	"MoveMemory__JLorg_eclipse_swt_internal_ole_win32_GUID_2I",
	"MoveMemory__JLorg_eclipse_swt_internal_ole_win32_OLEINPLACEFRAMEINFO_2I",
	"MoveMemory__JLorg_eclipse_swt_internal_ole_win32_STATSTG_2I",
	"MoveMemory__JLorg_eclipse_swt_internal_ole_win32_STGMEDIUM_2I",
	"MoveMemory__Lorg_eclipse_swt_internal_ole_win32_DISPPARAMS_2JI",
	"MoveMemory__Lorg_eclipse_swt_internal_ole_win32_FORMATETC_2JI",
	"MoveMemory__Lorg_eclipse_swt_internal_ole_win32_FUNCDESC_2JI",
	"MoveMemory__Lorg_eclipse_swt_internal_ole_win32_GUID_2JI",
	"MoveMemory__Lorg_eclipse_swt_internal_ole_win32_STATSTG_2JI",
	"MoveMemory__Lorg_eclipse_swt_internal_ole_win32_STGMEDIUM_2JI",
	"MoveMemory__Lorg_eclipse_swt_internal_ole_win32_TYPEATTR_2JI",
	"MoveMemory__Lorg_eclipse_swt_internal_ole_win32_VARDESC_2JI",
	"MoveMemory__Lorg_eclipse_swt_internal_ole_win32_VARIANT_2JI",
	"MoveMemory__Lorg_eclipse_swt_internal_win32_RECT_2JI",
	"OLECMD_1sizeof",
	"OLEINPLACEFRAMEINFO_1sizeof",
	"OleCreate",
	"OleCreateFromFile",
	"OleCreatePropertyFrame",
	"OleDraw",
	"OleFlushClipboard",
	"OleGetClipboard",
	"OleIsCurrentClipboard",
	"OleIsRunning",
	"OleLoad",
	"OleRun",
	"OleSave",
	"OleSetClipboard",
	"OleSetContainedObject",
	"OleSetMenuDescriptor",
	"OleTranslateColor",
	"ProgIDFromCLSID",
	"RegisterDragDrop",
	"ReleaseStgMedium",
	"RevokeDragDrop",
	"SHDoDragDrop",
	"STATSTG_1sizeof",
	"STGMEDIUM_1sizeof",
	"StgCreateDocfile",
	"StgIsStorageFile",
	"StgOpenStorage",
	"StringFromCLSID",
	"SysAllocString",
	"SysFreeString",
	"SysStringByteLen",
	"TYPEATTR_1sizeof",
	"TYPEDESC_1sizeof",
	"VARDESC_1sizeof",
	"VARIANT_1sizeof",
	"VariantChangeType",
	"VariantClear",
	"VariantInit",
	"VtblCall__IJIIII",
	"VtblCall__IJIIIII",
	"VtblCall__IJIIIIIJ",
	"VtblCall__IJIIIIJ",
	"VtblCall__IJIIJ",
	"VtblCall__IJIILorg_eclipse_swt_internal_ole_win32_DVTARGETDEVICE_2Lorg_eclipse_swt_internal_win32_SIZE_2",
	"VtblCall__IJII_3I",
	"VtblCall__IJII_3J",
	"VtblCall__IJIJ_3I",
	"VtblCall__IJILorg_eclipse_swt_internal_ole_win32_GUID_2",
	"VtblCall__IJILorg_eclipse_swt_internal_ole_win32_GUID_2IILorg_eclipse_swt_internal_ole_win32_DISPPARAMS_2JLorg_eclipse_swt_internal_ole_win32_EXCEPINFO_2_3I",
	"VtblCall__IJILorg_eclipse_swt_internal_ole_win32_GUID_2JJ",
	"VtblCall__IJILorg_eclipse_swt_internal_win32_MSG_2JIJLorg_eclipse_swt_internal_win32_RECT_2",
	"VtblCall__IJILorg_eclipse_swt_internal_win32_SIZE_2",
	"VtblCall__IJI_3I",
	"VtblCall__IJI_3J",
	"VtblCall__IJI_3JI_3I",
	"VtblCall__IJI_3J_3J_3I_3J",
	"VtblCall__IJJIIIIJ",
	"VtblCall__IJJI_3I",
	"VtblCall__IJJJ",
	"VtblCall__IJJJJJIIII",
	"VtblCall__IJJJLorg_eclipse_swt_internal_ole_win32_GUID_2J_3J",
	"VtblCall__IJJJLorg_eclipse_swt_internal_win32_POINT_2I",
	"VtblCall__IJJLorg_eclipse_swt_internal_ole_win32_FORMATETC_2_3J",
	"VtblCall__IJJLorg_eclipse_swt_internal_ole_win32_STATSTG_2_3J",
	"VtblCall__IJJLorg_eclipse_swt_internal_win32_POINT_2J",
	"VtblCall__IJJZ",
	"VtblCall__IJJ_3I",
	"VtblCall__IJLorg_eclipse_swt_internal_ole_win32_CAUUID_2",
	"VtblCall__IJLorg_eclipse_swt_internal_ole_win32_CONTROLINFO_2",
	"VtblCall__IJLorg_eclipse_swt_internal_ole_win32_FORMATETC_2",
	"VtblCall__IJLorg_eclipse_swt_internal_ole_win32_FORMATETC_2Lorg_eclipse_swt_internal_ole_win32_STGMEDIUM_2",
	"VtblCall__IJLorg_eclipse_swt_internal_ole_win32_FORMATETC_2Lorg_eclipse_swt_internal_ole_win32_STGMEDIUM_2Z",
	"VtblCall__IJLorg_eclipse_swt_internal_ole_win32_GUID_2",
	"VtblCall__IJLorg_eclipse_swt_internal_ole_win32_GUID_2IIJJ",
	"VtblCall__IJLorg_eclipse_swt_internal_ole_win32_GUID_2ILorg_eclipse_swt_internal_ole_win32_OLECMD_2Lorg_eclipse_swt_internal_ole_win32_OLECMDTEXT_2",
	"VtblCall__IJLorg_eclipse_swt_internal_ole_win32_GUID_2JII_3I",
	"VtblCall__IJLorg_eclipse_swt_internal_ole_win32_GUID_2Lorg_eclipse_swt_internal_ole_win32_GUID_2_3J",
	"VtblCall__IJLorg_eclipse_swt_internal_ole_win32_GUID_2_3J",
	"VtblCall__IJLorg_eclipse_swt_internal_ole_win32_LICINFO_2",
	"VtblCall__IJLorg_eclipse_swt_internal_win32_MSG_2",
	"VtblCall__IJLorg_eclipse_swt_internal_win32_POINT_2I",
	"VtblCall__IJLorg_eclipse_swt_internal_win32_RECT_2",
	"VtblCall__IJLorg_eclipse_swt_internal_win32_RECT_2JZ",
	"VtblCall__IJLorg_eclipse_swt_internal_win32_RECT_2Lorg_eclipse_swt_internal_win32_RECT_2",
	"VtblCall__IJLorg_eclipse_swt_internal_win32_SHDRAGIMAGE_2J",
	"VtblCall__IJZ",
	"VtblCall__IJ_3C",
	"VtblCall__IJ_3CIII_3I",
	"VtblCall__IJ_3CIII_3J",
	"VtblCall__IJ_3CJ",
	"VtblCall__IJ_3CJIII_3J",
	"VtblCall__IJ_3CJII_3J",
	"VtblCall__IJ_3C_3C",
	"VtblCall_1IVARIANT",
	"VtblCall_1IVARIANTP",
	"VtblCall_1PPPPVARIANT",
	"VtblCall_1PVARIANTP",
	"VtblCall_1VARIANT",
	"VtblCall_1VARIANTP",
	"WriteClassStg",
	"accDoDefaultAction_1CALLBACK",
	"accLocation_1CALLBACK",
	"accNavigate_1CALLBACK",
	"accSelect_1CALLBACK",
	"get_1accChild_1CALLBACK",
	"get_1accDefaultAction_1CALLBACK",
	"get_1accDescription_1CALLBACK",
	"get_1accHelpTopic_1CALLBACK",
	"get_1accHelp_1CALLBACK",
	"get_1accKeyboardShortcut_1CALLBACK",
	"get_1accName_1CALLBACK",
	"get_1accRole_1CALLBACK",
	"get_1accState_1CALLBACK",
	"get_1accValue_1CALLBACK",
	"put_1accName_1CALLBACK",
	"put_1accValue_1CALLBACK",
};

#define STATS_NATIVE(func) Java_org_eclipse_swt_tools_internal_NativeStats_##func

JNIEXPORT jint JNICALL STATS_NATIVE(COM_1GetFunctionCount)
	(JNIEnv *env, jclass that)
{
	return COM_nativeFunctionCount;
}

JNIEXPORT jstring JNICALL STATS_NATIVE(COM_1GetFunctionName)
	(JNIEnv *env, jclass that, jint index)
{
	return (*env)->NewStringUTF(env, COM_nativeFunctionNames[index]);
}

JNIEXPORT jint JNICALL STATS_NATIVE(COM_1GetFunctionCallCount)
	(JNIEnv *env, jclass that, jint index)
{
	return COM_nativeFunctionCallCount[index];
}

#endif
