/*******************************************************************************
 * Copyright (c) 2000, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.internal.gdip;

import org.eclipse.swt.internal.*;

public class Gdip extends Platform {
	static {
		Library.loadLibrary ("swt-gdip"); //$NON-NLS-1$
	}
	
	/** GdiPlus constants */
	public static final float FlatnessDefault = 0.25f;
	public static final int BrushTypeSolidColor = 0;
	public static final int BrushTypeHatchFill = 1;
	public static final int BrushTypeTextureFill = 2;
	public static final int BrushTypePathGradient = 3;
	public static final int BrushTypeLinearGradient = 4;
	public static final int ColorAdjustTypeBitmap = 1;
	public static final int ColorMatrixFlagsDefault = 0;
	public static final int CombineModeReplace = 0;
	public static final int CombineModeIntersect = 1;
	public static final int CombineModeUnion = 2;
	public static final int CombineModeXor = 3;
	public static final int CombineModeExclude = 4;
	public static final int CombineModeComplement = 5;
	public static final int FillModeAlternate = 0;
	public static final int FillModeWinding = 1;
	public static final int DashCapFlat = 0;
	public static final int DashCapRound = 2;
	public static final int DashCapTriangle = 3;
	public static final int DashStyleSolid = 0;
	public static final int DashStyleDash = 1;
	public static final int DashStyleDot = 2;
	public static final int DashStyleDashDot = 3;
	public static final int DashStyleDashDotDot = 4;
	public static final int DashStyleCustom = 5;
	public static final int FontStyleRegular = 0;
	public static final int FontStyleBold = 1;
	public static final int FontStyleItalic = 2;
	public static final int FontStyleBoldItalic = 3;
	public static final int FontStyleUnderline = 4;
	public static final int FontStyleStrikeout = 8;
	public static final int PaletteFlagsHasAlpha = 0x0001;
	public static final int FlushIntentionFlush = 0;
	public static final int FlushIntentionSync = 1;
	public static final int HotkeyPrefixNone = 0;
	public static final int HotkeyPrefixShow = 1;
	public static final int HotkeyPrefixHide = 2;
	public static final int LineJoinMiter = 0;
	public static final int LineJoinBevel = 1;
	public static final int LineJoinRound = 2;
	public static final int LineCapFlat = 0;
	public static final int LineCapSquare = 1;
	public static final int LineCapRound = 2;
	public static final int MatrixOrderPrepend = 0;
	public static final int MatrixOrderAppend = 1;
	public static final int QualityModeDefault = 0;
	public static final int QualityModeLow = 1;
	public static final int QualityModeHigh = 2;
	public static final int InterpolationModeDefault = QualityModeDefault;
	public static final int InterpolationModeLowQuality = QualityModeLow;
	public static final int InterpolationModeHighQuality = QualityModeHigh;
	public static final int InterpolationModeBilinear = QualityModeHigh + 1;
	public static final int InterpolationModeBicubic = QualityModeHigh + 2;
	public static final int InterpolationModeNearestNeighbor = QualityModeHigh + 3;
	public static final int InterpolationModeHighQualityBilinear = QualityModeHigh + 4;
	public static final int InterpolationModeHighQualityBicubic = QualityModeHigh + 5;
	public static final int PathPointTypeStart = 0;
	public static final int PathPointTypeLine = 1;
	public static final int PathPointTypeBezier = 3;
	public static final int PathPointTypePathTypeMask = 0x7;
	public static final int PathPointTypePathDashMode = 0x10;
	public static final int PathPointTypePathMarker = 0x20;
	public static final int PathPointTypeCloseSubpath = 0x80;
	public static final int PathPointTypeBezier3 = 3;
	public static final int PixelFormatIndexed = 0x00010000;
	public static final int PixelFormatGDI = 0x00020000;
	public static final int PixelFormatAlpha = 0x00040000;
	public static final int PixelFormatPAlpha = 0x00080000;
	public static final int PixelFormatExtended = 0x00100000;
	public static final int PixelFormatCanonical = 0x00200000;
	public static final int PixelFormat1bppIndexed = (1 | ( 1 << 8) | PixelFormatIndexed | PixelFormatGDI);
	public static final int PixelFormat4bppIndexed = (2 | ( 4 << 8) | PixelFormatIndexed | PixelFormatGDI);
	public static final int PixelFormat8bppIndexed = (3 | ( 8 << 8) | PixelFormatIndexed | PixelFormatGDI);
	public static final int PixelFormat16bppGrayScale = (4 | (16 << 8) | PixelFormatExtended);
	public static final int PixelFormat16bppRGB555 = (5 | (16 << 8) | PixelFormatGDI);
	public static final int PixelFormat16bppRGB565 = (6 | (16 << 8) | PixelFormatGDI);
	public static final int PixelFormat16bppARGB1555 = (7 | (16 << 8) | PixelFormatAlpha | PixelFormatGDI);
	public static final int PixelFormat24bppRGB = (8 | (24 << 8) | PixelFormatGDI);
	public static final int PixelFormat32bppRGB = (9 | (32 << 8) | PixelFormatGDI);
	public static final int PixelFormat32bppARGB = (10 | (32 << 8) | PixelFormatAlpha | PixelFormatGDI | PixelFormatCanonical);
	public static final int PixelFormat32bppPARGB = (11 | (32 << 8) | PixelFormatAlpha | PixelFormatPAlpha | PixelFormatGDI);
	public static final int PixelFormat48bppRGB = (12 | (48 << 8) | PixelFormatExtended);
	public static final int PixelFormat64bppARGB = (13 | (64 << 8) | PixelFormatAlpha  | PixelFormatCanonical | PixelFormatExtended);
	public static final int PixelFormat64bppPARGB = (14 | (64 << 8) | PixelFormatAlpha  | PixelFormatPAlpha | PixelFormatExtended);
	public static final int PixelFormatMax = 15;
	public static final int PixelOffsetModeNone = QualityModeHigh + 1;
	public static final int PixelOffsetModeHalf = QualityModeHigh + 2;
	public static final int SmoothingModeDefault = QualityModeDefault;
	public static final int SmoothingModeHighSpeed = QualityModeLow;
	public static final int SmoothingModeHighQuality = QualityModeHigh;
	public static final int SmoothingModeNone = 3;
	public static final int SmoothingModeAntiAlias8x4 = 4;
	public static final int SmoothingModeAntiAlias = SmoothingModeAntiAlias8x4;
	public static final int SmoothingModeAntiAlias8x8 = 5;
	public static final int StringFormatFlagsDirectionRightToLeft = 0x00000001;
	public static final int StringFormatFlagsDirectionVertical = 0x00000002;
	public static final int StringFormatFlagsNoFitBlackBox = 0x00000004;
	public static final int StringFormatFlagsDisplayFormatControl = 0x00000020;
	public static final int StringFormatFlagsNoFontFallback = 0x00000400;
	public static final int StringFormatFlagsMeasureTrailingSpaces = 0x00000800;
	public static final int StringFormatFlagsNoWrap = 0x00001000;
	public static final int StringFormatFlagsLineLimit = 0x00002000;
	public static final int StringFormatFlagsNoClip = 0x00004000;
	public static final int TextRenderingHintSystemDefault = 0;
	public static final int TextRenderingHintSingleBitPerPixelGridFit = 1;
	public static final int TextRenderingHintSingleBitPerPixel = 2;
	public static final int TextRenderingHintAntiAliasGridFit = 3;
	public static final int TextRenderingHintAntiAlias = 4;
	public static final int TextRenderingHintClearTypeGridFit = 5;
	public static final int UnitPixel = 2;
	public static final int WrapModeTile = 0;
	public static final int WrapModeTileFlipX = 1;
	public static final int WrapModeTileFlipY = 2;
	public static final int WrapModeTileFlipXY = 3;
	public static final int WrapModeClamp = 4;

/** 64 bit */
public static final native int ColorPalette_sizeof();
public static final native int GdiplusStartupInput_sizeof();

/** GdiPlus natives */
public static final native int GdiplusStartup(long /*int*/[] token, GdiplusStartupInput input, long /*int*/ output);
public static final native void GdiplusShutdown(long /*int*/ token);
public static final native long /*int*/ Bitmap_new(long /*int*/ hbm, long /*int*/ hpal);
public static final native long /*int*/ Bitmap_new(long /*int*/ hicon);
public static final native long /*int*/ Bitmap_new(int width, int height, int stride, int format, long /*int*/ scan0);
public static final native long /*int*/ Bitmap_new(char[] filename, boolean useIcm);
public static final native void Bitmap_delete(long /*int*/ bitmap);
public static final native int Bitmap_GetHBITMAP(long /*int*/ bitmap, long /*int*/ colorBackground, long /*int*/[] hbmReturn);
public static final native int Bitmap_GetHICON(long /*int*/ bitmap, long /*int*/[] hicon);
public static final native long /*int*/ BitmapData_new();
public static final native void BitmapData_delete(long /*int*/ bitmapData);
public static final native int Bitmap_LockBits(long /*int*/ bitmap, long /*int*/ rect, int flags, int pixelFormat, long /*int*/ lockedBitmapData);
public static final native int Bitmap_UnlockBits(long /*int*/ bitmap, long /*int*/ lockedBitmapData);
public static final native long /*int*/ Brush_Clone(long /*int*/ brush);
public static final native int Brush_GetType(long /*int*/ brush);
public static final native long /*int*/ Color_new(int argb);
public static final native void Color_delete(long /*int*/ color);
public static final native long /*int*/ Font_new(long /*int*/ hdc, long /*int*/ hfont);
public static final native long /*int*/ Font_new(char[] familyName, float emSize, int style, int unit, long /*int*/ fontCollection);
public static final native void Font_delete(long /*int*/ font);
public static final native int Font_GetFamily(long /*int*/ font, long /*int*/ family);
public static final native float Font_GetSize(long /*int*/ font);
public static final native int Font_GetStyle(long /*int*/ font);
public static final native boolean Font_IsAvailable(long /*int*/ font);
public static final native long /*int*/ FontFamily_new();
public static final native void FontFamily_delete(long /*int*/ family);
public static final native int FontFamily_GetFamilyName(long /*int*/ family, char[] name, char language);
public static final native long /*int*/ Graphics_new(long /*int*/ hdc);
public static final native void Graphics_delete(long /*int*/ graphics);
public static final native int Graphics_DrawArc(long /*int*/ graphics, long /*int*/ pen, int x, int y, int width, int height, float startAngle, float sweepAngle);
public static final native int Graphics_DrawEllipse(long /*int*/ graphics, long /*int*/ pen, int x, int y, int width, int height);
public static final native int Graphics_DrawImage(long /*int*/ graphics, long /*int*/ image, int x, int y);
public static final native int Graphics_DrawImage(long /*int*/ graphics, long /*int*/ image, Rect destRect, int srcx, int srcy, int srcwidth, int srcheight, int srcUnit, long /*int*/ imageAttributes, long /*int*/ callback, long /*int*/ callbackData);
public static final native int Graphics_DrawLine(long /*int*/ graphics, long /*int*/ pen, int x1, int y1, int x2, int y2);
public static final native int Graphics_DrawLines(long /*int*/ graphics, long /*int*/ pen, int[] points, int count);
public static final native int Graphics_DrawPath(long /*int*/ graphics, long /*int*/ pen, long /*int*/ path);
public static final native int Graphics_DrawPolygon(long /*int*/ graphics, long /*int*/ pen, int[] points, int count);
public static final native int Graphics_DrawRectangle(long /*int*/ graphics, long /*int*/ pen, int x, int y, int width, int height);
public static final native int Graphics_DrawString(long /*int*/ graphics, char[] string, int length, long /*int*/ font, PointF origin, long /*int*/ brush);
public static final native int Graphics_DrawString(long /*int*/ graphics, char[] string, int length, long /*int*/ font, PointF origin, long /*int*/ format, long /*int*/ brush);
public static final native int Graphics_FillEllipse(long /*int*/ graphics, long /*int*/ brush, int x, int y, int width, int height);
public static final native int Graphics_FillPath(long /*int*/ graphics, long /*int*/ brush, long /*int*/ path);
public static final native void Graphics_Flush(long /*int*/ graphics, int intention);
public static final native int Graphics_FillPie(long /*int*/ graphics, long /*int*/ brush, int x, int y, int width, int height, float startAngle, float sweepAngle);
public static final native int Graphics_FillPolygon(long /*int*/ graphics, long /*int*/ brush, int[] points, int count, int fillMode);
public static final native int Graphics_FillRectangle(long /*int*/ graphics, long /*int*/ brush, int x, int y, int width, int height);
public static final native int Graphics_GetClipBounds(long /*int*/ graphics, RectF rect);
public static final native int Graphics_GetClipBounds(long /*int*/ graphics, Rect rect);
public static final native int Graphics_GetClip(long /*int*/ graphics, long /*int*/ region);
public static final native long /*int*/ Graphics_GetHDC(long /*int*/ graphics);
public static final native void Graphics_ReleaseHDC(long /*int*/ graphics, long /*int*/ hdc);
public static final native int Graphics_GetInterpolationMode(long /*int*/ graphics);
public static final native int Graphics_GetSmoothingMode(long /*int*/ graphics);
public static final native int Graphics_GetTextRenderingHint(long /*int*/ graphics);
public static final native int Graphics_GetTransform(long /*int*/ graphics, long /*int*/ matrix);
public static final native int Graphics_GetVisibleClipBounds(long /*int*/ graphics, Rect rect);
public static final native int Graphics_MeasureString(long /*int*/ graphics, char[] string, int length, long /*int*/ font, PointF origin, RectF boundingBox);
public static final native int Graphics_MeasureString(long /*int*/ graphics, char[] string, int length, long /*int*/ font, PointF origin, long /*int*/ format, RectF boundingBox);
public static final native int Graphics_ResetClip(long /*int*/ graphics);
public static final native int Graphics_Restore(long /*int*/ graphics, int gstate);
public static final native int Graphics_Save(long /*int*/ graphics);
public static final native int Graphics_ScaleTransform(long /*int*/ graphics, float sx, float sy, int order);
public static final native int Graphics_SetClip(long /*int*/ graphics, long /*int*/ hrgn, int combineMode);
public static final native int Graphics_SetClip(long /*int*/ graphics, Rect rect, int combineMode);
public static final native int Graphics_SetClipPath(long /*int*/ graphics, long /*int*/ path);
public static final native int Graphics_SetClipPath(long /*int*/ graphics, long /*int*/ path, int combineMode);
public static final native int Graphics_SetCompositingQuality(long /*int*/ graphics, int compositingQuality);
public static final native int Graphics_SetPageUnit(long /*int*/ graphics, int unit);
public static final native int Graphics_SetPixelOffsetMode(long /*int*/ graphics, int pixelOffsetMode);
public static final native int Graphics_SetSmoothingMode(long /*int*/ graphics, int smoothingMode);
public static final native int Graphics_SetTransform(long /*int*/ graphics, long /*int*/ matrix);
public static final native int Graphics_SetInterpolationMode(long /*int*/ graphics, int mode);
public static final native int Graphics_SetTextRenderingHint(long /*int*/ graphics, int mode);
public static final native int Graphics_TranslateTransform(long /*int*/ graphics, float dx, float dy, int order);
public static final native long /*int*/ GraphicsPath_new(int fillMode);
public static final native long /*int*/ GraphicsPath_new(int[] points, byte[] types, int count, int fillMode);
public static final native void GraphicsPath_delete(long /*int*/ path);
public static final native int GraphicsPath_AddArc(long /*int*/ path, float x, float y, float width, float height, float startAngle, float sweepAngle);
public static final native int GraphicsPath_AddBezier(long /*int*/ path, float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4);
public static final native int GraphicsPath_AddLine(long /*int*/ path, float x1, float y1, float x2, float y2);
public static final native int GraphicsPath_AddPath(long /*int*/ path, long /*int*/ addingPath, boolean connect);
public static final native int GraphicsPath_AddRectangle(long /*int*/ path, RectF rect);
public static final native int GraphicsPath_AddString(long /*int*/ path, char[] string, int length, long /*int*/ family, int style, float emSize, PointF origin, long /*int*/ format);
public static final native int GraphicsPath_CloseFigure(long /*int*/ path);
public static final native long /*int*/ GraphicsPath_Clone(long /*int*/ path);
public static final native int GraphicsPath_Flatten(long /*int*/ path, long /*int*/ matrix, float flatness);
public static final native int GraphicsPath_GetBounds(long /*int*/ path, RectF bounds, long /*int*/ matrix, long /*int*/ pen);
public static final native int GraphicsPath_GetLastPoint(long /*int*/ path, PointF lastPoint);
public static final native int GraphicsPath_GetPathPoints(long /*int*/ path, float[] points, int count);
public static final native int GraphicsPath_GetPathTypes(long /*int*/ path, byte[] types, int count);
public static final native int GraphicsPath_GetPointCount(long /*int*/ path);
public static final native boolean GraphicsPath_IsOutlineVisible(long /*int*/ path, float x, float y, long /*int*/ pen, long /*int*/ g);
public static final native boolean GraphicsPath_IsVisible(long /*int*/ path, float x, float y, long /*int*/ g);
public static final native int GraphicsPath_SetFillMode(long /*int*/ path, int fillmode);
public static final native int GraphicsPath_StartFigure(long /*int*/ path);
public static final native int GraphicsPath_Transform(long /*int*/ path, long /*int*/ matrix);
public static final native long /*int*/ HatchBrush_new(int hatchStyle, long /*int*/ foreColor, long /*int*/ backColor);
public static final native int Image_GetLastStatus(long /*int*/ image);
public static final native int Image_GetPixelFormat(long /*int*/ image);
public static final native int Image_GetWidth(long /*int*/ image);
public static final native int Image_GetHeight(long /*int*/ image);
public static final native int Image_GetPalette(long /*int*/ image, long /*int*/ palette, int size);
public static final native int Image_GetPaletteSize(long /*int*/ image);
public static final native long /*int*/ ImageAttributes_new();
public static final native void ImageAttributes_delete(long /*int*/ attrib);
public static final native int ImageAttributes_SetWrapMode(long /*int*/ attrib, int wrap);
public static final native int ImageAttributes_SetColorMatrix(long /*int*/ attrib, float[] matrix, int mode, int type);
public static final native void HatchBrush_delete(long /*int*/ brush);
public static final native long /*int*/ LinearGradientBrush_new(PointF point1, PointF point2, long /*int*/ color1, long /*int*/ color2);
public static final native void LinearGradientBrush_delete(long /*int*/ brush);
public static final native int LinearGradientBrush_SetInterpolationColors(long /*int*/ brush, long /*int*/[] presetColors, float[] blendPositions, int count);
public static final native int LinearGradientBrush_SetWrapMode(long /*int*/ brush, int wrapMode);
public static final native int LinearGradientBrush_ResetTransform(long /*int*/ brush);
public static final native int LinearGradientBrush_ScaleTransform(long /*int*/ brush, float sx, float sy, int order);
public static final native int LinearGradientBrush_TranslateTransform(long /*int*/ brush, float dx, float dy, int order);
public static final native long /*int*/ Matrix_new(float m11, float m12, float m21, float m22, float dx, float dy);
public static final native void Matrix_delete(long /*int*/ matrix);
public static final native int Matrix_GetElements(long /*int*/ matrix, float[] m);
public static final native int Matrix_Invert(long /*int*/ matrix);
public static final native boolean Matrix_IsIdentity(long /*int*/ matrix);
public static final native int Matrix_Multiply(long /*int*/ matrix, long /*int*/ matrix1, int order);
public static final native int Matrix_Rotate(long /*int*/ matrix, float angle, int order);
public static final native int Matrix_Scale(long /*int*/ matrix, float scaleX, float scaleY, int order);
public static final native int Matrix_Shear(long /*int*/ matrix, float shearX, float shearY, int order);
public static final native int Matrix_TransformPoints(long /*int*/ matrix, PointF pts, int count);
public static final native int Matrix_TransformPoints(long /*int*/ matrix, float[] pts, int count);
public static final native int Matrix_Translate(long /*int*/ matrix, float offsetX, float offsetY, int order);
public static final native int Matrix_SetElements(long /*int*/ matrix, float m11, float m12, float m21, float m22, float dx, float dy);
public static final native void MoveMemory(ColorPalette Destination, long /*int*/ SourcePtr, int Length);
public static final native void MoveMemory(BitmapData Destination, long /*int*/ SourcePtr);
public static final native long /*int*/ PathGradientBrush_new(long /*int*/ path);
public static final native void PathGradientBrush_delete(long /*int*/ brush);
public static final native int PathGradientBrush_SetCenterColor(long /*int*/ brush, long /*int*/ color);
public static final native int PathGradientBrush_SetCenterPoint(long /*int*/ brush, PointF pt);
public static final native int PathGradientBrush_SetInterpolationColors(long /*int*/ brush, long /*int*/[] presetColors, float[] blendPositions, int count);
public static final native int PathGradientBrush_SetSurroundColors(long /*int*/ brush, long /*int*/[] colors, int[] count);
public static final native int PathGradientBrush_SetGraphicsPath(long /*int*/ brush, long /*int*/ path);
public static final native int PathGradientBrush_SetWrapMode(long /*int*/ brush, int wrapMode);
public static final native long /*int*/ Pen_new(long /*int*/ brush, float width);
public static final native void Pen_delete(long /*int*/ pen);
public static final native long /*int*/ Pen_GetBrush(long /*int*/ pen);
public static final native int Pen_SetBrush(long /*int*/ pen, long /*int*/ brush);
public static final native int Pen_SetDashOffset(long /*int*/ pen, float dashOffset);
public static final native int Pen_SetDashPattern(long /*int*/ pen, float[] dashArray, int count);
public static final native int Pen_SetDashStyle(long /*int*/ pen, int dashStyle);
public static final native int Pen_SetLineCap(long /*int*/ pen, int startCap, int endCap, int dashCap);
public static final native int Pen_SetLineJoin(long /*int*/ pen, int lineJoin);
public static final native int Pen_SetMiterLimit(long /*int*/ pen, float miterLimit);
public static final native int Pen_SetWidth(long /*int*/ pen, float width);
public static final native long /*int*/ Point_new(int x, int y);
public static final native void Point_delete(long /*int*/ point);
public static final native long /*int*/ Region_new(long /*int*/ hRgn);
public static final native long /*int*/ Region_newGraphicsPath(long /*int*/ path);
public static final native long /*int*/ Region_new();
public static final native void Region_delete(long /*int*/ region);
public static final native long /*int*/ Region_GetHRGN(long /*int*/ region, long /*int*/ graphics);
public static final native boolean Region_IsInfinite(long /*int*/ region, long /*int*/ graphics);
public static final native long /*int*/ SolidBrush_new(long /*int*/ color);
public static final native void SolidBrush_delete(long /*int*/ brush);
public static final native void StringFormat_delete(long /*int*/ format);
public static final native long /*int*/ StringFormat_Clone(long /*int*/ format);
public static final native long /*int*/ StringFormat_GenericDefault();
public static final native long /*int*/ StringFormat_GenericTypographic();
public static final native int StringFormat_GetFormatFlags(long /*int*/ format);
public static final native int StringFormat_SetHotkeyPrefix(long /*int*/ format, int hotkeyPrefix);
public static final native int StringFormat_SetFormatFlags(long /*int*/ format, int flags);
public static final native int StringFormat_SetTabStops(long /*int*/ format, float firstTabOffset, int count, float[] tabStops);
public static final native long /*int*/ TextureBrush_new(long /*int*/ image, int wrapMode, float dstX, float dstY, float dstWidth, float dstHeight);
public static final native void TextureBrush_delete(long /*int*/ brush);
public static final native int TextureBrush_SetTransform(long /*int*/ brush, long /*int*/ matrix);
public static final native int TextureBrush_ResetTransform(long /*int*/ brush);
public static final native int TextureBrush_ScaleTransform(long /*int*/ brush, float sx, float sy, int order);
public static final native int TextureBrush_TranslateTransform(long /*int*/ brush, float dx, float dy, int order);
}
