/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.pde.internal.p2.ui;

import org.eclipse.ui.plugin.AbstractUIPlugin;

public class Activator extends AbstractUIPlugin {
	
	public static final String PLUGIN_ID = "org.eclipse.pde.p2.ui"; //$NON-NLS-1$
	
	private static Activator fgPDEP2Plugin; 
	
	/**
	 * Constructs the PDE p2 UI plug-in
	 */
	public Activator() {
		super();
		fgPDEP2Plugin = this;
	}
	
	/**
	 * Convenience method which returns the unique identifier of this plug-in.
	 */
	public static String getUniqueIdentifier() {
		return PLUGIN_ID;
	}
	
	/**
	 * Returns the singleton instance of the debug plug-in.
	 */
	public static Activator getDefault() {
		if(fgPDEP2Plugin == null) {
			fgPDEP2Plugin = new Activator();
		}
		return fgPDEP2Plugin;
	}

}
