/**
 * <copyright>
 *
 * Copyright (c) 2003-2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: EChangeSummary.java,v 1.10 2008/05/04 17:03:39 emerks Exp $
 */
package org.eclipse.emf.ecore.sdo;

import org.eclipse.emf.ecore.change.ChangeDescription;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataObject;
import commonj.sdo.Property;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>EChange Summary</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.emf.ecore.sdo.EChangeSummary#getEDataGraph <em>EData Graph</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.emf.ecore.sdo.SDOPackage#getEChangeSummary()
 * @model superTypes="org.eclipse.emf.ecore.change.ChangeDescription org.eclipse.emf.ecore.sdo.ChangeSummary"
 * @generated
 */
public interface EChangeSummary extends ChangeDescription, ChangeSummary
{
  /**
   * Returns the value of the '<em><b>EData Graph</b></em>' reference.
   * It is bidirectional and its opposite is '{@link org.eclipse.emf.ecore.sdo.EDataGraph#getEChangeSummary <em>EChange Summary</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the value of the '<em>EData Graph</em>' reference.
   * @see #setEDataGraph(EDataGraph)
   * @see org.eclipse.emf.ecore.sdo.SDOPackage#getEChangeSummary_EDataGraph()
   * @see org.eclipse.emf.ecore.sdo.EDataGraph#getEChangeSummary
   * @model opposite="eChangeSummary" resolveProxies="false" required="true" transient="true"
   * @generated
   */
  EDataGraph getEDataGraph();

  /**
   * Sets the value of the '{@link org.eclipse.emf.ecore.sdo.EChangeSummary#getEDataGraph <em>EData Graph</em>}' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>EData Graph</em>' reference.
   * @see #getEDataGraph()
   * @generated
   */
  void setEDataGraph(EDataGraph value);

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @model
   * @generated
   */
  void summarize();

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @model
   * @generated
   */
  void resumeLogging();

  /**
   * Returns whether or not the specified data object was changed while {@link ChangeSummary#isLogging logging}.
   * Any modified object that was {@link DataObject#getDataGraph contained} in the data graph when
   * logging began and remains in the graph when logging ends will be considered changed.
   * @param dataObject the data object in question.
   * @return <code>true</code> if the specified data object was changed.
   * @see ChangeSummary#getChangedDataObjects()
   */
  boolean isChanged(DataObject dataObject);   

  /**
   * Returns a {@link ChangeSummary.Setting setting} for the specified property
   * representing the property value of the given <code>dataObject</code>
   * at the point when logging {@link #beginLogging() began}.
   * <p>Returns null if the property has not changed and 
   * has not been {@link #isDeleted(DataObject) deleted}. 
   * @param dataObject the object in question.
   * @param property the property of the object.
   * @return the setting for the specified property.
   * @see ChangeSummary#getChangedDataObjects()
   */
  Setting getOldValue(DataObject dataObject, Property property);

  /**
   * Returns the value of the {@link DataObject#getContainer container} data object
   * at the point when logging {@link #beginLogging() began}.
   * @param dataObject the object in question.
   * @return the old container data object.
   */
  DataObject getOldContainer(DataObject dataObject);

  /**
   * Returns the value of the {@link DataObject#getContainmentProperty containment property} data
   * object property at the point when logging {@link #beginLogging() began}.
   * @param dataObject the object in question.
   * @return the old containment property.
   */
  Property getOldContainmentProperty(DataObject dataObject);  

} // EChangeSummary
