/**
 * <copyright>
 *
 * Copyright (c) 2003-2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: SDOAdapterFactory.java,v 1.7 2007/10/27 10:29:08 emerks Exp $
 */
package org.eclipse.emf.ecore.sdo.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.sdo.*;

import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.SimpleAnyType;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.Type;

import java.io.Serializable;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.emf.ecore.sdo.SDOPackage
 * @generated
 */
public class SDOAdapterFactory extends AdapterFactoryImpl
{
  /**
   * The cached model package.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected static SDOPackage modelPackage;

  /**
   * Creates an instance of the adapter factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public SDOAdapterFactory()
  {
    if (modelPackage == null)
    {
      modelPackage = SDOPackage.eINSTANCE;
    }
  }

  /**
   * Returns whether this factory is applicable for the type of the object.
   * <!-- begin-user-doc -->
   * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
   * <!-- end-user-doc -->
   * @return whether this factory is applicable for the type of the object.
   * @generated
   */
  @Override
  public boolean isFactoryForType(Object object)
  {
    if (object == modelPackage)
    {
      return true;
    }
    if (object instanceof EObject)
    {
      return ((EObject)object).eClass().getEPackage() == modelPackage;
    }
    return false;
  }

  /**
   * The switch that delegates to the <code>createXXX</code> methods.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected SDOSwitch<Adapter> modelSwitch =
    new SDOSwitch<Adapter>()
    {
      @Override
      public Adapter caseEChangeSummary(EChangeSummary object)
      {
        return createEChangeSummaryAdapter();
      }
      @Override
      public Adapter caseEChangeSummarySetting(EChangeSummarySetting object)
      {
        return createEChangeSummarySettingAdapter();
      }
      @Override
      public Adapter caseEDataGraph(EDataGraph object)
      {
        return createEDataGraphAdapter();
      }
      @Override
      public Adapter caseEDataObject(EDataObject object)
      {
        return createEDataObjectAdapter();
      }
      @Override
      public Adapter caseEProperty(EProperty object)
      {
        return createEPropertyAdapter();
      }
      @Override
      public Adapter caseChangeSummary(ChangeSummary object)
      {
        return createChangeSummaryAdapter();
      }
      @Override
      public Adapter caseChangeSummarySetting(ChangeSummary.Setting object)
      {
        return createChangeSummarySettingAdapter();
      }
      @Override
      public Adapter caseDataGraph(DataGraph object)
      {
        return createDataGraphAdapter();
      }
      @Override
      public Adapter caseDataObject(DataObject object)
      {
        return createDataObjectAdapter();
      }
      @Override
      public Adapter caseESequence(ESequence object)
      {
        return createESequenceAdapter();
      }
      @Override
      public Adapter caseEType(EType object)
      {
        return createETypeAdapter();
      }
      @Override
      public Adapter caseProperty(Property object)
      {
        return createPropertyAdapter();
      }
      @Override
      public Adapter caseSequence(Sequence object)
      {
        return createSequenceAdapter();
      }
      @Override
      public Adapter caseType(Type object)
      {
        return createTypeAdapter();
      }
      @Override
      public Adapter caseInternalEDataObject(InternalEDataObject object)
      {
        return createInternalEDataObjectAdapter();
      }
      @Override
      public Adapter caseEDataObjectAnyType(EDataObjectAnyType object)
      {
        return createEDataObjectAnyTypeAdapter();
      }
      @Override
      public Adapter caseEDataObjectSimpleAnyType(EDataObjectSimpleAnyType object)
      {
        return createEDataObjectSimpleAnyTypeAdapter();
      }
      @Override
      public Adapter caseEJavaSerializable(Serializable object)
      {
        return createEJavaSerializableAdapter();
      }
      @Override
      public Adapter caseChangeDescription(ChangeDescription object)
      {
        return createChangeDescriptionAdapter();
      }
      @Override
      public Adapter caseFeatureChange(FeatureChange object)
      {
        return createFeatureChangeAdapter();
      }
      @Override
      public Adapter caseAnyType(AnyType object)
      {
        return createAnyTypeAdapter();
      }
      @Override
      public Adapter caseSimpleAnyType(SimpleAnyType object)
      {
        return createSimpleAnyTypeAdapter();
      }
      @Override
      public Adapter defaultCase(EObject object)
      {
        return createEObjectAdapter();
      }
    };

  /**
   * Creates an adapter for the <code>target</code>.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param target the object to adapt.
   * @return the adapter for the <code>target</code>.
   * @generated
   */
  @Override
  public Adapter createAdapter(Notifier target)
  {
    return modelSwitch.doSwitch((EObject)target);
  }


  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.sdo.EDataObject <em>EData Object</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.sdo.EDataObject
   * @generated
   */
  public Adapter createEDataObjectAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.sdo.EDataGraph <em>EData Graph</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.sdo.EDataGraph
   * @generated
   */
  public Adapter createEDataGraphAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.sdo.EChangeSummary <em>EChange Summary</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.sdo.EChangeSummary
   * @generated
   */
  public Adapter createEChangeSummaryAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.sdo.EProperty <em>EProperty</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.sdo.EProperty
   * @generated
   */
  public Adapter createEPropertyAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link commonj.sdo.DataObject <em>Data Object</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see commonj.sdo.DataObject
   * @generated
   */
  public Adapter createDataObjectAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.sdo.util.ESequence <em>ESequence</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.sdo.util.ESequence
   * @generated
   */
  public Adapter createESequenceAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link commonj.sdo.DataGraph <em>Data Graph</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see commonj.sdo.DataGraph
   * @generated
   */
  public Adapter createDataGraphAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link commonj.sdo.ChangeSummary <em>Change Summary</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see commonj.sdo.ChangeSummary
   * @generated
   */
  public Adapter createChangeSummaryAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.sdo.EType <em>EType</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.sdo.EType
   * @generated
   */
  public Adapter createETypeAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link commonj.sdo.Type <em>Type</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see commonj.sdo.Type
   * @generated
   */
  public Adapter createTypeAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link commonj.sdo.Property <em>Property</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see commonj.sdo.Property
   * @generated
   */
  public Adapter createPropertyAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link commonj.sdo.Sequence <em>Sequence</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see commonj.sdo.Sequence
   * @generated
   */
  public Adapter createSequenceAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.sdo.EChangeSummarySetting <em>EChange Summary Setting</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.sdo.EChangeSummarySetting
   * @generated
   */
  public Adapter createEChangeSummarySettingAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.sdo.InternalEDataObject <em>Internal EData Object</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.sdo.InternalEDataObject
   * @generated
   */
  public Adapter createInternalEDataObjectAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.sdo.EDataObjectAnyType <em>EData Object Any Type</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.sdo.EDataObjectAnyType
   * @generated
   */
  public Adapter createEDataObjectAnyTypeAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.sdo.EDataObjectSimpleAnyType <em>EData Object Simple Any Type</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.sdo.EDataObjectSimpleAnyType
   * @generated
   */
  public Adapter createEDataObjectSimpleAnyTypeAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link java.io.Serializable <em>EJava Serializable</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see java.io.Serializable
   * @generated
   */
  public Adapter createEJavaSerializableAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.change.ChangeDescription <em>Description</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.change.ChangeDescription
   * @generated
   */
  public Adapter createChangeDescriptionAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.change.FeatureChange <em>Feature Change</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.change.FeatureChange
   * @generated
   */
  public Adapter createFeatureChangeAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.xml.type.AnyType <em>Any Type</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.xml.type.AnyType
   * @generated
   */
  public Adapter createAnyTypeAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.xml.type.SimpleAnyType <em>Simple Any Type</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.xml.type.SimpleAnyType
   * @generated
   */
  public Adapter createSimpleAnyTypeAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link commonj.sdo.ChangeSummary.Setting <em>Change Summary Setting</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see commonj.sdo.ChangeSummary.Setting
   * @generated
   */
  public Adapter createChangeSummarySettingAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for the default case.
   * <!-- begin-user-doc -->
   * This default implementation returns null.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @generated
   */
  public Adapter createEObjectAdapter()
  {
    return null;
  }

} //SDOAdapterFactory
