/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.internal.wpf;


import org.eclipse.swt.internal.*;

public class OS extends C {
	
	/** Constants */
	public static final int BindingFlags_Instance = 4;
	public static final int BindingFlags_NonPublic = 32;
	
	public static final int DragAction_Cancel = 2;
	public static final int DragAction_Continue = 0;
	public static final int DragAction_Drop = 1;

	public static final int DragDropEffects_Copy = 1;
	public static final int DragDropEffects_Link = 4;
	public static final int DragDropEffects_Move = 2;
	public static final int DragDropEffects_None = 0;

	public static final int DragDropKeyStates_AltKey = 32;
	public static final int DragDropKeyStates_ControlKey = 8;
	public static final int DragDropKeyStates_None = 0;
	public static final int DragDropKeyStates_ShiftKey = 4;

	public static final int FontStyle_Bold = 1;
	public static final int FontStyle_Italic = 2;
	public static final int FontStyle_Regular = 0;
	public static final int FontStyle_Strikeout = 8;
	public static final int FontStyle_Underline = 4;

	public static final int Key_LeftAlt = 120;
	public static final int Key_RightAlt = 121;
	public static final int Key_LeftCtrl = 118;
	public static final int Key_RightCtrl = 119;
	public static final int Key_LeftShift = 116;
	public static final int Key_RightShift = 117;
	public static final int Key_Left = 23;
	public static final int Key_Up = 24;
	public static final int Key_Right = 25;
	public static final int Key_Down = 26;
	public static final int Key_PageUp = 19;
	public static final int Key_PageDown = 20;
	public static final int Key_End = 21;
	public static final int Key_Home = 22;
	public static final int Key_Insert = 31;
	public static final int Key_ImeProcessed = 155;
	public static final int Key_F1 = 90;
	public static final int Key_F2 = 91;
	public static final int Key_F3 = 92;
	public static final int Key_F4 = 93;
	public static final int Key_F5 = 94;
	public static final int Key_F6 = 95;
	public static final int Key_F7 = 96;
	public static final int Key_F8 = 97;
	public static final int Key_F9 = 98;
	public static final int Key_F10 = 99;
	public static final int Key_F11 = 100;
	public static final int Key_F12 = 101;
	public static final int Key_F13 = 102;
	public static final int Key_F14 = 103;
	public static final int Key_F15 = 104;
	public static final int Key_Back = 2;
	public static final int Key_Return = 6;
	public static final int Key_Delete = 32;
	public static final int Key_Escape = 13;
	public static final int Key_Tab = 3;
	public static final int Key_LineFeed = 4;
	public static final int Key_NumPad0 = 74;
	public static final int Key_NumPad1 = 75;
	public static final int Key_NumPad2 = 76;
	public static final int Key_NumPad3 = 77;
	public static final int Key_NumPad4 = 78;
	public static final int Key_NumPad5 = 79;
	public static final int Key_NumPad6 = 80;
	public static final int Key_NumPad7 = 81;
	public static final int Key_NumPad8 = 82;
	public static final int Key_NumPad9 = 83;
	public static final int Key_Multiply = 84;
	public static final int Key_Add = 85;
	public static final int Key_Separator = 86;
	public static final int Key_Subtract = 87;
	public static final int Key_System = 156;
	public static final int Key_Decimal = 88;
	public static final int Key_Divide = 89;
	public static final int Key_CapsLock = 8;
	public static final int Key_PrintScreen = 30;
	public static final int Key_Pause = 7;
	public static final int Key_Cancel = 1;
	public static final int Key_NumLock = 114;
	public static final int Key_Scroll = 115;
	public static final int Key_D0 = 34;
	public static final int Key_D1 = 35;
	public static final int Key_D2 = 36;
	public static final int Key_D3 = 37;
	public static final int Key_D4 = 38;
	public static final int Key_D5 = 39;
	public static final int Key_D6 = 40;
	public static final int Key_D7 = 41;
	public static final int Key_D8 = 42;
	public static final int Key_D9 = 43;
	public static final int Key_A = 44;
	public static final int Key_B = 45;
	public static final int Key_C = 46;
	public static final int Key_D = 47;
	public static final int Key_E = 48;
	public static final int Key_F = 49;
	public static final int Key_G = 50;
	public static final int Key_H = 51;
	public static final int Key_I = 52;
	public static final int Key_J = 53;
	public static final int Key_K = 54;
	public static final int Key_L = 55;
	public static final int Key_M = 56;
	public static final int Key_N = 57;
	public static final int Key_O = 58;
	public static final int Key_P = 59;
	public static final int Key_Q = 60;
	public static final int Key_R = 61;
	public static final int Key_S = 62;
	public static final int Key_T = 63;
	public static final int Key_U = 64;
	public static final int Key_V = 65;
	public static final int Key_W = 66;
	public static final int Key_X = 67;
	public static final int Key_Y = 68;
	public static final int Key_Z = 69;
	public static final int Key_OemTilde = 146;
	public static final int Key_Oem2 = 145;
	public static final int Key_Oem4 = 149;
	public static final int Key_Oem6 = 151;
	public static final int Key_Oem7 = 152;
	public static final int Key_OemPipe = 150;
	public static final int Key_OemMinus = 143;
	public static final int Key_OemPlus = 141;
	public static final int Key_OemSemicolon = 140;
	public static final int Key_OemComma = 142;
	public static final int Key_OemPeriod = 144;
	
	public static final byte Visibility_Visible = 0;
	public static final byte Visibility_Hidden = 1;
	public static final byte Visibility_Collapsed = 2;
	
	public static final int GridUnitType_Auto = 0;
	public static final int GridUnitType_Pixel = 1;
	public static final int GridUnitType_Star = 2;
	
	public static final int Orientation_Horizontal = 0; 
	public static final int Orientation_Vertical = 1;
	
	public static final int OverflowMode_Never = 2;
	
	public static final int NavigationUIVisibility_Hidden = 2;
	
	public static final int ScrollEventType_EndScroll = 0;
	public static final int ScrollEventType_First = 1;
	public static final int ScrollEventType_LargeDecrement = 2;
	public static final int ScrollEventType_LargeIncrement = 3;
	public static final int ScrollEventType_Last = 4;
	public static final int ScrollEventType_SmallDecrement = 5;
	public static final int ScrollEventType_SmallIncrement = 6;
	public static final int ScrollEventType_ThumbPosition = 7;
	public static final int ScrollEventType_ThumbTrack = 8;
	
	public static final int ShutdownMode_OnExplicitShutdown = 2;
	
	public static final int HorizontalAlignment_Left = 0;
	public static final int HorizontalAlignment_Center = 1;
	public static final int HorizontalAlignment_Right = 2;
	public static final int HorizontalAlignment_Stretch = 3;
	
	public static final int VerticalAlignment_Top = 0;
	public static final int VerticalAlignment_Center = 1;
	public static final int VerticalAlignment_Bottom = 2;
	public static final int VerticalAlignment_Stretch = 3;
	
	public static final int UriKind_RelativeOrAbsolute = 0;
	public static final int UriKind_Absolute = 1;
	public static final int UriKind_Relative = 2;
	
	public static final int Stretch_None = 0;
	public static final int Stretch_Fill = 1;
	public static final int Stretch_Uniform = 2;
	public static final int Stretch_UniformToFill = 3;
	
	public static final int PenLineCap_Flat = 0;
	public static final int PenLineCap_Round = 1;
	public static final int PenLineCap_Square = 2;
	
	public static final int PenLineJoin_Miter = 0;
	public static final int PenLineJoin_Bevel = 1;
	public static final int PenLineJoin_Round = 2;
	
	public static final int SweepDirection_Clockwise = 0;
	public static final int SweepDirection_CounterClockwise = 1;
	
	public static final int FillRule_EvenOdd = 0;
	public static final int FillRule_Nonzero = 1;
	
	public static final int BitmapScalingMode_Unspecified = 0;
	public static final int BitmapScalingMode_LowQuality = 1;
	public static final int BitmapScalingMode_HighQuality = 2;

	public static final int EdgeMode_Unspecified = 0;
	public static final int EdgeMode_Aliased = 1;
	
	public static final int FlowDirection_LeftToRight = 0;
	public static final int FlowDirection_RightToLeft = 1;

	public static final int TileMode_Tile = 4;
	
	public static final int AlignmentX_Left = 0;
	public static final int AlignmentX_Center = 1;
	public static final int AlignmentX_Right = 2;
	public static final int AlignmentY_Top = 0;
	public static final int AlignmentY_Center = 1;
	public static final int Alignmenty_Bottom = 2;
	
	public static final int BrushMappingMode_Absolute = 0;
	public static final int BrushMappingMode_RelativeToBoundingBox = 1;

	public static final int GradientSpreadMethod_Pad = 0;
	public static final int GradientSpreadMethod_Reflect = 1;
	public static final int GradientSpreadMethod_Repeat = 2;
	
	public static final int GeometryCombineMode_Union = 0;
	public static final int GeometryCombineMode_Intersect = 1;
	public static final int GeometryCombineMode_Xor = 2;
	public static final int GeometryCombineMode_Exclude = 3;
	
	public static final int TextAlignment_Left = 0;
	public static final int TextAlignment_Right = 1;
	public static final int TextAlignment_Center = 2;
	public static final int TextAlignment_Justify = 3;
	
	public static final int BaselineAlignment_Baseline = 3;
	
	public static final int TextWrapping_WrapWithOverflow = 0;
	public static final int TextWrapping_NoWrap = 1;
	public static final int TextWrapping_Wrap = 2;
		
	public static final int IntersectionDetail_Empty = 1;
	
	public static final int TextTabAlignment_Left = 0;
	
	public static final int MouseButtonState_Released = 0;
	public static final int MouseButtonState_Pressed = 1;
	
	public static final int MouseButton_Left = 0;
	public static final int MouseButton_Middle = 1;
	public static final int MouseButton_Right = 2;
	public static final int MouseButton_XButton1 = 3;
	public static final int MouseButton_XButton2 = 4;
	
	public static final int MouseButtons_None = 0;
	public static final int MouseButtons_Left = 1048576;
	public static final int MouseButtons_Right = 2097152;
	public static final int MouseButtons_Middle = 4194304;
	public static final int MouseButtons_XButton1 = 8388608;
	public static final int MouseButtons_XButton2 = 16777216;
	
	public static final int ModifierKeys_Alt = 1;
	public static final int ModifierKeys_Control = 2;
	public static final int ModifierKeys_Shift = 4;
	
	public static final int ResizeMode_NoResize = 0;
	public static final int ResizeMode_CanMinimize = 1;
	public static final int ResizeMode_CanResize = 2;
	public static final int ResizeMode_CanResizeWithGrip = 3;
	
	public static final int WindowStyle_None = 0;
	public static final int WindowStyle_SingleBorderWindow = 1;
	public static final int WindowStyle_ThreeDBorderWindow = 2;
	public static final int WindowStyle_ToolWindow = 3;
	

	public static final int WebBrowserReadyState_Uninitialized = 0;
	public static final int WebBrowserReadyState_Loading = 1;
	public static final int WebBrowserReadyState_Loaded = 2;
	public static final int WebBrowserReadyState_Interactive = 3;
	public static final int WebBrowserReadyState_Complete = 4;
	
	public static final int Dock_Top = 1;
	public static final int Dock_Bottom = 3;

	public static final int SelectionMode_Single = 0;
	public static final int SelectionMode_Multiple = 1;
	public static final int SelectionMode_Extended = 2;
	
	public static final int TickPlacement_None = 0;
    public static final int TickPlacement_TopLeft = 1;
    public static final int TickPlacement_BottomRight = 2;
	public static final int TickPlacement_Both = 3;

	public static final int WindowState_Normal = 0;
    public static final int WindowState_Minimized = 1;
    public static final int WindowState_Maximized = 2;
    
    public static final int BitmapCreateOptions_None = 0;
    public static final int BitmapCreateOptions_PreservePixelFormat = 1;
    public static final int BitmapCacheOption_Default = 0;
    
    public static final int MessageBoxButton_OK = 0;
    public static final int MessageBoxButton_OKCancel = 1;
    public static final int MessageBoxButton_YesNoCancel = 3;
    public static final int MessageBoxButton_YesNo = 4;
    
    public static final int MessageBoxImage_None = 0;
    public static final int MessageBoxImage_Error = 16;
    public static final int MessageBoxImage_Hand = 16;
    public static final int MessageBoxImage_Stop = 16;
    public static final int MessageBoxImage_Question = 32;
    public static final int MessageBoxImage_Exclamation = 48;
    public static final int MessageBoxImage_Warning = 48;
    public static final int MessageBoxImage_Information = 64;
    public static final int MessageBoxImage_Asterisk = 64;
    
    public static final int MessageBoxResult_None = 0;
    public static final int MessageBoxResult_OK = 1;
    public static final int MessageBoxResult_Cancel = 2;
    public static final int MessageBoxResult_Yes = 6;
    public static final int MessageBoxResult_No = 7;
    
    public static final int KeyboardNavigationMode_None = 3;
    
    public static final int PlacementMode_AbsolutePoint = 5;
    public static final int PlacementMode_MousePoint = 8;
    
    public static final int DispatcherPriority_Inactive = 0;
    public static final int DispatcherPriority_Normal = 9;
    public static final int DispatcherPriority_Send = 10;
    
    public static final int ScrollBarVisibility_Disabled = 0;
    public static final int ScrollBarVisibility_Auto = 1;
    public static final int ScrollBarVisibility_Hidden = 2;
    public static final int ScrollBarVisibility_Visible = 3;
 
 	public static final int FocusNavigationDirection_Next = 0;
	public static final int FocusNavigationDirection_Previous = 1;
	public static final int FocusNavigationDirection_First = 2;
	public static final int FocusNavigationDirection_Last = 3;
	
	public static final int RelativeSourceMode_FindAncestor = 3;

	public static final int DialogResult_OK = 1;
	
	public static final int TextDecorationUnit_FontRecommended = 0;
	public static final int TextDecorationLocation_Underline = 0;
	public static final int TextDecorationLocation_Strikethrough = 2;
	
	public static final int ToleranceType_Absolute = 0;
	

	/*
	* Note that these GCHandles are leaked.
	*/
	public static final int FontStyles_Italic = FontStyles_Italic();
	public static final int FontStyles_Normal = FontStyles_Normal();	
	public static final int FontStyles_Oblique = FontStyles_Oblique();	
	public static final int FontWeights_Bold = FontWeights_Bold();
	public static final int FontWeights_Normal = FontWeights_Normal();	
	public static final int FontStretches_Normal = FontStretches_Normal();
	public static final int Colors_White = Colors_White();
	public static final int Colors_Black = Colors_Black();
	public static final int Colors_Transparent = Colors_Transparent();
	public static final int SystemColors_ControlColor = SystemColors_ControlColor();

/** Handlers */
public static final native int gcnew_CancelEventHandler(int jniRef, String string);
public static final native int gcnew_ContextMenuEventHandler(int jniRef, String string);
public static final native int gcnew_RoutedPropertyChangedEventHandler(int jniRef, String string);
public static final native int gcnew_RoutedPropertyChangedEventHandlerObject(int jniRef, String string);
public static final native int gcnew_RoutedEventHandler(int jniRef, String string);
public static final native int gcnew_DragDeltaEventHandler(int jniRef, String string);
public static final native int gcnew_EventHandler(int jniRef, String string);
public static final native int gcnew_ExecutedRoutedEventHandler(int jniRef, String string);
public static final native int gcnew_FormsMouseEventHandler(int jniRef, String string);
public static final native int gcnew_DispatcherHookEventHandler(int jniRef, String string);
public static final native int gcnew_SelectionChangedEventHandler(int jniRef, String string);
public static final native int gcnew_SizeChangedEventHandler(int jniRef, String string);
public static final native int gcnew_ScrollEventHandler(int jniRef, String string);
public static final native int gcnew_KeyEventHandler(int jniRef, String string);
public static final native int gcnew_KeyboardFocusChangedEventHandler(int jniRef, String string);
public static final native int gcnew_TextChangedEventHandler(int jniRef, String string);
public static final native int gcnew_TextCompositionEventHandler(int jniRef, String string);
public static final native int gcnew_TimerHandler(int jniRef, String string);
public static final native int gcnew_MouseEventHandler(int jniRef, String string);
public static final native int gcnew_MouseButtonEventHandler(int jniRef, String string);
public static final native int gcnew_MouseWheelEventHandler(int jniRef, String string);
public static final native int gcnew_NoArgsDelegate(int jniRef, String string);
public static final native int gcnew_GiveFeedbackEventHandler(int jniRef, String string);
public static final native int gcnew_QueryContinueDragEventHandler(int jniRef, String string);
public static final native int gcnew_DragEventHandler(int jniRef, String string);
public static final native int gcnew_WebBrowserNavigatingEventHandler(int jniRef, String string);
public static final native int gcnew_WebBrowserNavigatedEventHandler(int jniRef, String string);
public static final native int gcnew_WebBrowserProgressChangedEventHandler(int jniRef, String string);
public static final native int gcnew_WebBrowserDocumentCompletedEventHandler(int jniRef, String string);

/** JNI natives */
public static final native int NewGlobalRef(Object object);
public static final native void DeleteGlobalRef(int globalRef);
public static final native Object JNIGetObject(int globalRef);

/** Natives */
public static final native char AccessText_AccessKey(int sender);
public static final native void AccessText_Text(int sender, int value);
public static final native void AccessText_TextWrapping(int sender, int value);
public static final native int ApplicationCommands_Cut();
public static final native int ApplicationCommands_Paste();
public static final native int ApplicationCommands_Redo();
public static final native int ApplicationCommands_Undo();
public static final native int Application_Current();
public static final native int Application_Dispatcher(int sender);
public static final native int Application_Resources(int sender);
public static final native void Application_Resources(int sender, int value);
public static final native void Application_Run(int sender);
public static final native void Application_Shutdown(int sender);
public static final native void Application_ShutdownMode(int sender, int value);
public static final native int Application_Windows(int sender);
public static final native int Array_CreateInstance(int elementType, int length);
public static final native int Array_GetLength(int sender, int dimension);
public static final native int Array_GetValue (int sender, int index);
public static final native void Array_SetValue (int sender, int value, int index);
public static final native void ArrayList_Clear(int sender);
public static final native int ArrayList_Count(int sender);
public static final native int ArrayList_default(int sender, int index);
public static final native void ArrayList_default(int sender, int index, int value);
public static final native void ArrayList_Insert(int sender, int index, int value);
public static final native void ArrayList_RemoveAt(int sender, int index);
public static final native void Binding_RelativeSource(int sender, int value);
public static final native int Bitmap_GetHicon(int sender);
public static final native int BitmapDecoder_Create(int stream, int createOptions, int cacheOption);
public static final native int BitmapDecoder_Frames(int sender);
public static final native int BitmapEncoder_Frames(int sender);
public static final native void BitmapEncoder_Save(int sender, int stream);
public static final native int BitmapFrame_Create(int source);
public static final native void BitmapFrameCollection_Add(int sender, int frame);
public static final native int BitmapFrameCollection_default(int sender, int index);
public static final native void BitmapImage_BeginInit(int sender);
public static final native void BitmapImage_CreateOptions(int sender, int value);
public static final native void BitmapImage_EndInit(int sender);
public static final native void BitmapImage_UriSource(int sender, int uri);
public static final native int BitmapPalette_Colors(int sender);
public static final native int BitmapSource_Clone(int sender);
public static final native int BitmapSource_Create(int pixelWidth, int pixelHeight, double dpiX, double dpiY, int pixelFormat, int palette, byte[] buffer, int bufferSize, int stride);
public static final native void BitmapSource_CopyPixels(int sender, int sourceRect, byte[] buffer, int bufferSize, int stride);
public static final native int BitmapSource_Format(int sender);
public static final native int BitmapSource_Palette(int sender);
public static final native int BitmapSource_PixelHeight(int sender);
public static final native int BitmapSource_PixelWidth(int sender);
public static final native int Border_typeid();
public static final native int Brushes_White();
public static final native int Brushes_Black();
public static final native int Brushes_Navy();
public static final native int Brushes_Red();
public static final native int Brushes_Transparent();
public static final native int Brushes_LightSkyBlue();
public static final native void Brush_Opacity(int sender, double opacity);
public static final native boolean Button_IsDefault(int sender);
public static final native void Button_IsDefault(int sender, boolean value);
public static final native void ButtonBase_Click(int sender, int handler);
public static final native int ButtonBase_ClickEvent();
public static final native int Byte_typeid();
public static final native void CancelEventArgs_Cancel(int sender, boolean value);
public static final native double Canvas_GetLeft(int element);
public static final native double Canvas_GetTop(int element);
public static final native void Canvas_SetLeft(int element, double length);
public static final native void Canvas_SetTop(int element, double length);
public static final native int Canvas_typeid();
public static final native int CharacterHit_FirstCharacterIndex(int sender);
public static final native int CharacterHit_TrailingLength(int sender);
public static final native int CheckBox_typeid();
public static final native void Clipboard_Clear();
public static final native boolean Clipboard_ContainsData(int format);
public static final native int Clipboard_GetData(int format);
public static final native int Clipboard_GetDataObject();
public static final native int Clipboard_GetText();
public static final native void Clipboard_SetData(int format, int data);
public static final native void Clipboard_SetDataObject(int data, boolean copy);
public static final native int Color_FromArgb(byte a, byte r, byte g, byte b);
public static final native byte Color_A(int sender);
public static final native byte Color_B(int sender);
public static final native byte Color_G(int sender);
public static final native byte Color_R(int sender);
public static final native void ColorDialog_AnyColor(int sender, boolean value);
public static final native void ColorDialog_Color(int sender, int color);
public static final native int ColorDialog_Color(int sender);
public static final native void ColorDialog_CustomColors(int sender, int colors);
public static final native int ColorDialog_CustomColors(int sender);
public static final native void ColorList_Add(int sender, int color);
public static final native int ColorList_Count(int sender);
public static final native int ColorList_Current(int sender);
public static final native int ColorList_GetEnumerator(int sender);
public static final native int Colors_White();
public static final native int Colors_Black();
public static final native int Colors_Red();
public static final native int Colors_Maroon();
public static final native int Colors_Lime();
public static final native int Colors_Green();
public static final native int Colors_Olive();
public static final native int Colors_Blue();
public static final native int Colors_Navy();
public static final native int Colors_LightSkyBlue();
public static final native int Colors_Magenta();
public static final native int Colors_Purple();
public static final native int Colors_Cyan();
public static final native int Colors_Teal();
public static final native int Colors_Transparent();
public static final native int Colors_Silver();
public static final native int Colors_DarkGray();
public static final native int Colors_Yellow();
public static final native void ColumnDefinition_Width(int sender, int width);
public static final native void ColumnDefinitionCollection_Add(int sender, int column);
public static final native boolean ComboBox_IsDropDownOpen(int sender);
public static final native void ComboBox_IsDropDownOpen(int sender, boolean value);
public static final native void ComboBox_IsEditable(int sender, boolean value);
public static final native int ComboBox_SelectionBoxItem(int handle);
public static final native void CommandManager_AddPreviewExecutedHandler(int sender, int handler);
public static final native boolean CommonDialog_ShowDialog(int sender, int parent);
public static final native int CompositeCollection_IndexOf(int sender, int object);
public static final native void CompositeCollection_Insert(int sender, int index, int value);
public static final native void CompositeCollection_Remove(int sender, int value);
public static final native void CompositeCollection_RemoveAt(int sender, int value);
public static final native void Console_Beep();
public static final native int Control_Padding(int sender);
public static final native void Control_Padding(int sender, int value);
public static final native int ContainerVisual_Clip(int sender);
public static final native void ContainerVisual_Clip(int sender, int clip);
public static final native int ContentControl_Content(int sender);
public static final native void ContentControl_Content(int sender, int content);
public static final native int ContentPresenter_Content(int sender);
public static final native int ContentPresenter_typeid();
public static final native void ContextMenu_IsOpen(int sender, boolean value);
public static final native void ContextMenu_Placement(int sender, int mode);
public static final native void ContextMenu_HorizontalOffset(int sender, int offset);
public static final native void ContextMenu_VerticalOffset(int sender, int offset);
public static final native void ContextMenu_Opened(int sender, int handler);
public static final native void ContextMenu_Closed(int sender, int handler);
public static final native double ContextMenuEventArgs_CursorLeft(int sender);
public static final native double ContextMenuEventArgs_CursorTop(int sender);
public static final native int Control_BackgroundProperty();
public static final native int Control_BorderBrushProperty();
public static final native int Control_BorderThicknessProperty();
public static final native int Control_ForegroundProperty();
public static final native int Control_FontFamilyProperty();
public static final native int Control_FontStyleProperty();
public static final native int Control_FontWeightProperty();
public static final native int Control_FontStretchProperty();
public static final native int Control_FontSizeProperty();
public static final native void Control_BorderThickness(int sender, int value);
public static final native void Control_Background(int sender, int value);
public static final native void Control_Foreground(int sender, int value);
public static final native int Control_FontFamily(int sender);
public static final native void Control_FontFamily(int sender, int value);
public static final native void Control_FontStyle(int sender, int value);
public static final native void Control_FontWeight(int sender, int value);
public static final native void Control_FontStretch(int sender, int value);
public static final native double Control_FontSize(int sender);
public static final native void Control_FontSize(int sender, double value);
public static final native int Control_HorizontalContentAlignment(int sender);
public static final native void Control_HorizontalContentAlignment(int sender, int value);
public static final native void Control_MouseDoubleClick(int sender, int handler);
public static final native int Control_MouseDoubleClickEvent();
public static final native void Control_PreviewMouseDoubleClick(int sender, int handler);
public static final native int Control_Template(int sender);
public static final native void Control_Template(int sender, int value);
public static final native int Control_TemplateProperty();
public static final native void Control_VerticalContentAlignment(int sender, int value);
public static final native int CultureInfo_CurrentUICulture();
public static final native int Cursors_AppStarting();
public static final native int Cursors_Arrow();
public static final native int Cursors_Hand();
public static final native int Cursors_Wait();
public static final native int Cursors_Cross();
public static final native int Cursors_Help();
public static final native int Cursors_SizeAll();
public static final native int Cursors_SizeNS();
public static final native int Cursors_SizeNWSE();
public static final native int Cursors_SizeNESW();
public static final native int Cursors_SizeWE();
public static final native int Cursors_ScrollE();
public static final native int Cursors_ScrollN();
public static final native int Cursors_ScrollNE();
public static final native int Cursors_ScrollNW();
public static final native int Cursors_ScrollS();
public static final native int Cursors_ScrollSE();
public static final native int Cursors_ScrollSW();
public static final native int Cursors_ScrollW();
public static final native int Cursors_IBeam();
public static final native int Cursors_UpArrow();
public static final native int Cursors_No();
public static final native int CursorInteropHelper_Create(int safeHandle);
public static final native int DashStyles_Dash();
public static final native int DashStyles_DashDot();
public static final native int DashStyles_DashDotDot();
public static final native int DashStyles_Dot();
public static final native int DashStyles_Solid();
public static final native int DataFormats_Bitmap();
public static final native int DataFormats_FileDrop();
public static final native int DataFormats_Html();
public static final native int DataFormats_Rtf();
public static final native int DataFormats_UnicodeText();
public static final native int DataObject_GetData(int sender, int format, boolean autoConvert);
public static final native boolean DataObject_GetDataPresent(int sender, int format, boolean autoConvert);
public static final native int DataObject_GetFormats(int sender, boolean autoConvert);
public static final native void DataObject_SetData(int sender, int format, int data, boolean autoConvert);
public static final native void DependencyObject_ClearValue(int sender, int property);
public static final native int DependencyObject_GetValue(int sender, int property);
public static final native double DependencyObject_GetValueDouble(int sender, int property);
public static final native int DependencyObject_GetValueInt(int sender, int property);
public static final native void DependencyObject_SetValue(int sender, int property, int object);
public static final native int DependencyProperty_UnsetValue();
public static final native void DependencyPropertyDescriptor_AddValueChanged(int sender, int object, int handler);
public static final native int DependencyPropertyDescriptor_FromProperty(int dp, int type);
public static final native void Dispatcher_PushFrame(int frame);
public static final native int Dispatcher_Hooks(int sender);
public static final native void DispatcherHooks_DispatcherInactive(int sender, int handler);
public static final native void DispatcherHooks_OperationAborted(int sender, int handler);
public static final native void DispatcherHooks_OperationCompleted(int sender, int handler);
public static final native void DispatcherHooks_OperationPosted(int sender, int handler);
public static final native boolean DispatcherFrame_Continue(int sender);
public static final native void DispatcherFrame_Continue(int sender, boolean value);
public static final native int DispatcherHookEventArgs_Operation(int sender);
public static final native boolean DispatcherOperation_Abort(int sender);
public static final native int DispatcherOperation_Priority(int sender);
public static final native void DispatcherOperation_Priority(int sender, int value);
public static final native int DispatcherOperation_Wait(int sender);
public static final native int Dispatcher_BeginInvoke(int sender, int priority, int method);
public static final native void DispatcherTimer_Interval(int sender, int value);
public static final native void DispatcherTimer_Start(int sender);
public static final native void DispatcherTimer_Stop(int sender);
public static final native void DispatcherTimer_Tag(int sender, int value);
public static final native int DispatcherTimer_Tag(int sender);
public static final native void DispatcherTimer_Tick(int sender, int handler);
public static final native int DockPanel_DockProperty();
public static final native int DockPanel_typeid();
public static final native void DoubleCollection_Add(int sender, double value);
public static final native int DoubleAnimationUsingKeyFrames_KeyFrames(int sender);
public static final native int DoubleKeyFrameCollection_Add(int sender, int keyFrame);
public static final native int DragDeltaEventArgs_VerticalChange(int e);
public static final native int DragDeltaEventArgs_HorizontalChange(int e);
public static final native int DragDrop_DoDragDrop(int dragSource, int data, int allowedEffects);
public static final native int DragEventArgs_AllowedEffects (int sender);
public static final native int DragEventArgs_Data (int sender);
public static final native int DragEventArgs_Effects (int sender);
public static final native void DragEventArgs_Effects (int sender, int effects);
public static final native int DragEventArgs_GetPosition (int sender, int relativeTo);
public static final native int DragEventArgs_KeyStates (int sender);
public static final native int DrawingColor_FromArgb(int a, int r, int g, int b);
public static final native int DrawingColor_ToArgb(int sender);
public static final native void DrawingContext_Close(int sender);
public static final native void DrawingContext_DrawDrawing(int sender, int Drawing);
public static final native void DrawingContext_DrawEllipse(int sender, int brush, int pen, int center, double radiusX, double radiusY);
public static final native void DrawingContext_DrawImage(int sender, int imagesource, int rect);
public static final native void DrawingContext_DrawLine(int sender, int pen, int point0, int point1);
public static final native void DrawingContext_DrawGeometry(int sender, int brush, int pen, int geometry);
public static final native void DrawingContext_DrawRectangle(int sender, int brush, int pen, int rect);
public static final native void DrawingContext_DrawRoundedRectangle(int sender, int brush, int pen, int rect, double radiusX, double radiusY);
public static final native void DrawingContext_DrawText(int sender, int formattedText, int point);
public static final native int DrawingFontFamily_Name(int sender);
public static final native void DrawingContext_PushTransform(int sender, int transform);
public static final native void DrawingContext_PushClip(int sender, int clipGeometry);
public static final native void DrawingContext_PushOpacity(int sender, double opacity);
public static final native void DrawingContext_Pop(int sender);
public static final native int DrawingVisual_Drawing(int sender);
public static final native int DrawingVisual_RenderOpen(int sender);
public static final native int DrawingVisual_typeid();
public static final native int EditingCommands_Backspace();
public static final native int EditingCommands_Delete();
public static final native int EditingCommands_DeleteNextWord();
public static final native int EditingCommands_DeletePreviousWord();
public static final native int Environment_ExpandEnvironmentVariables(int string);
public static final native int ExecutedRoutedEventArgs_Command(int sender);
public static final native void ExecutedRoutedEventArgs_Handled(int sender, boolean handled);
public static final native void Expander_Collapsed(int sender, int handler);
public static final native void Expander_Expanded(int sender, int handler);
public static final native boolean Expander_IsExpanded(int sender);
public static final native void Expander_IsExpanded(int sender, boolean value);
public static final native void FileDialog_FileName(int sender, int value);
public static final native int FileDialog_FileNames(int sender);
public static final native void FileDialog_Filter(int sender, int value);
public static final native int FileDialog_FilterIndex(int sender);
public static final native void FileDialog_FilterIndex(int sender, int value);
public static final native void FileDialog_InitialDirectory(int sender, int value);
public static final native void FileDialog_Title(int sender, int value);
public static final native int FileInfo_DirectoryName(int sender);
public static final native int FileInfo_Name(int sender);
public static final native boolean File_Exists(int sender);
public static final native int File_ReadAllText(int sender);
public static final native int FocusManager_GetFocusScope(int element);
public static final native int FocusManager_GetFocusedElement(int element);
public static final native void FolderBrowserDialog_Description(int sender, int value);
public static final native int FolderBrowserDialog_SelectedPath(int sender);
public static final native void FolderBrowserDialog_SelectedPath(int sender, int value);
public static final native int Font_FontFamily(int sender);
public static final native int Font_Size(int sender);
public static final native int Font_Style(int sender);
public static final native int FontDialog_Color(int sender);
public static final native void FontDialog_Color(int sender, int value);
public static final native int FontDialog_Font(int sender);
public static final native void FontDialog_Font(int sender, int value);
public static final native void FontDialog_ShowColor (int sender, boolean value);
public static final native int FontFamily_GetTypefaces(int sender);
public static final native double FontFamily_LineSpacing(int sender);
public static final native int FontFamily_Source(int sender);
public static final native int FontStyles_Italic();
public static final native int FontStyles_Normal();
public static final native int FontStyles_Oblique();
public static final native int FontWeight_FromOpenTypeWeight(int weight);
public static final native int FontWeight_ToOpenTypeWeight(int sender);
public static final native int FontWeights_Bold();
public static final native int FontWeights_Normal();
public static final native int FontStretches_Normal();
public static final native int FontStretch_FromOpenTypeStretch(int stretch);
public static final native int FontStretch_ToOpenTypeStretch(int sender);
public static final native int Fonts_GetTypefaces(int uri);
public static final native int Fonts_SystemTypefaces();
public static final native double FormattedText_Baseline(int sender);
public static final native int FormattedText_BuildGeometry(int sender, int origin);
public static final native int FormattedText_BuildHighlightGeometry(int sender, int origin);
public static final native double FormattedText_Height(int sender);
public static final native void FormattedText_SetTextDecorations(int sender, int decorations, int startIndex, int count);
public static final native double FormattedText_WidthIncludingTrailingWhitespace(int sender);
public static final native int FormsCommonDialog_ShowDialog(int sender);
public static final native int FormsMouseEventArgs_Button(int sender);
public static final native boolean Frame_CanGoBack(int sender);
public static final native boolean Frame_CanGoForward(int sender);
public static final native int Frame_CurrentSource(int sender);
public static final native int Frame_Source(int sender);
public static final native void Frame_Source(int sender, int uri);
public static final native boolean Frame_Navigate(int sender, int uri);
public static final native void Frame_NavigationUIVisibility(int sender, int visiblity);
public static final native void Frame_GoBack(int sender);
public static final native void Frame_GoForward(int sender);
public static final native void Frame_Refresh(int sender);
public static final native void Frame_StopLoading(int sender);
public static final native int FrameworkContentElement_Parent(int sender);
public static final native int FrameworkContentElement_Tag(int sender);
public static final native void FrameworkContentElement_Tag(int sender, int value);
public static final native int FrameworkContentElement_typeid();
public static final native void FrameworkElement_BeginInit(int sender);
public static final native void FrameworkElement_BringIntoView(int sender);
public static final native void FrameworkElement_ContextMenu(int sender, int value);
public static final native void FrameworkElement_ContextMenuClosing(int sender, int handler);
public static final native void FrameworkElement_ContextMenuOpening(int sender, int handler);
public static final native void FrameworkElement_Cursor(int sender, int cursor);
public static final native int FrameworkElement_CursorProperty();
public static final native int FrameworkElement_ActualHeightProperty();
public static final native int FrameworkElement_ActualWidthProperty();
public static final native int FrameworkElement_FindResource(int sender, int key);
public static final native void FrameworkElement_FocusVisualStyle(int sender, int style);
public static final native int FrameworkElement_FlowDirection(int sender);
public static final native void FrameworkElement_FlowDirection(int sender, int value);
public static final native int FrameworkElement_GetBindingExpression(int sender, int dp);
public static final native void FrameworkElement_HorizontalAlignment(int sender, int value);
public static final native boolean FrameworkElement_IsLoaded(int sender);
public static final native void FrameworkElement_LayoutTransform(int sender, int value);
public static final native void FrameworkElement_Loaded(int sender, int handler);
public static final native int FrameworkElement_Margin(int sender);
public static final native void FrameworkElement_Margin(int sender, int value);
public static final native int FrameworkElement_MarginProperty();
public static final native int FrameworkElement_Name(int sender);
public static final native int FrameworkElement_NameProperty();
public static final native int FrameworkElement_Parent(int sender);
public static final native int FrameworkElement_RenderTransform(int sender);
public static final native void FrameworkElement_RenderTransform(int sender, int value);
public static final native int FrameworkElement_Style(int sender);
public static final native void FrameworkElement_Style(int sender, int value);
public static final native int FrameworkElement_StyleProperty();
public static final native int FrameworkElement_Tag(int sender);
public static final native void FrameworkElement_Tag(int sender, int tag);
public static final native int FrameworkElement_TagProperty();
public static final native int FrameworkElement_typeid();
public static final native int FrameworkElement_ToolTip(int sender);
public static final native void FrameworkElement_ToolTip(int sender, int value);
public static final native double FrameworkElement_MaxHeight(int sender);
public static final native void FrameworkElement_MaxHeight(int sender, double height);
public static final native double FrameworkElement_MaxWidth(int sender);
public static final native void FrameworkElement_MaxWidth(int sender, double width);
public static final native double FrameworkElement_MinHeight(int sender);
public static final native void FrameworkElement_MinHeight(int sender, double height);
public static final native double FrameworkElement_MinWidth(int sender);
public static final native void FrameworkElement_MinWidth(int sender, double width);
public static final native double FrameworkElement_Height(int sender);
public static final native void FrameworkElement_Height(int sender, double height);
public static final native double FrameworkElement_Width(int sender);
public static final native void FrameworkElement_Width(int sender, double width);
public static final native double FrameworkElement_ActualWidth(int sender);
public static final native double FrameworkElement_ActualHeight(int sender);
public static final native int FrameworkElement_WidthProperty();
public static final native int FrameworkElement_HeightProperty();
public static final native void FrameworkElement_SizeChanged(int sender, int handler);
public static final native int FrameworkElement_SizeChangedEvent();
public static final native void FrameworkElement_VerticalAlignment(int sender, int str);
public static final native int FrameworkElement_VerticalAlignmentProperty();
public static final native void FrameworkElementFactory_AppendChild(int sender, int value);
public static final native void FrameworkElementFactory_SetBinding(int sender, int dp, int binding);
public static final native void FrameworkElementFactory_SetValue(int sender, int dp, boolean value);
public static final native void FrameworkElementFactory_SetValue(int sender, int dp, int value);
public static final native void FrameworkElementFactory_SetValueDock(int sender, int dp, int value);
public static final native void FrameworkElementFactory_SetValueInt(int sender, int dp, int value);
public static final native void FrameworkElementFactory_SetValueStretch(int sender, int dp, int value);
public static final native void FrameworkElementFactory_SetValueOrientation(int sender, int dp, int value);
public static final native void FrameworkElementFactory_SetValueVerticalAlignment(int sender, int dp, int value);
public static final native void FrameworkElementFactory_SetValueVisibility(int sender, int dp, byte value);
public static final native int FrameworkTemplate_FindName(int sender, int name, int parent);
public static final native void FrameworkTemplate_VisualTree(int sender, int value);
public static final native boolean Freezable_CanFreeze(int sender);
public static final native int Freezable_Clone(int sender);
public static final native void Freezable_Freeze(int sender);
public static final native void GeometryCollection_Clear(int sender);
public static final native int GeometryCollection_Count(int sender);
public static final native void GeometryCollection_Add(int sender, int geometry);
public static final native void GeometryCollection_Remove(int sender, int geometry);
public static final native int Geometry_Clone(int sender);
public static final native int Geometry_Bounds(int sender);
public static final native int Geometry_GetFlattenedPathGeometry(int sender);
public static final native int Geometry_GetFlattenedPathGeometry(int sender, double tolerance, int type);
public static final native boolean Geometry_IsEmpty(int sender);
public static final native boolean Geometry_FillContains(int sender, int point);
public static final native int Geometry_FillContainsWithDetail(int sender, int geometry);
public static final native boolean Geometry_StrokeContains(int sender, int pen, int hitPoint);
public static final native int Geometry_Transform(int sender);
public static final native void Geometry_Transform(int sender, int transform);
public static final native int GeometryGroup_Children(int sender);
public static final native int GeometryGroup_Children(int sender, int index);
public static final native int GiveFeedbackEventArgs_Effects (int sender);
public static final native int GlyphRun_BidiLevel(int sender);
public static final native void GradientBrush_MappingMode(int sender, int mode);
public static final native void GradientBrush_SpreadMethod(int sender, int method);
public static final native int Grid_ColumnDefinitions(int sender);
public static final native int Grid_RowDefinitions(int sender);
public static final native void Grid_SetColumn(int element, int index);
public static final native void Grid_SetColumnSpan(int element, int value);
public static final native void Grid_SetRow(int element, int index);
public static final native void Grid_SetRowSpan(int element, int value);
public static final native void GridView_ColumnHeaderContainerStyle(int sender, int style);
public static final native int GridView_Columns(int sender);
public static final native void GridView_AllowsColumnReorder(int sender, boolean value);
public static final native double GridViewColumn_ActualWidth(int sender);
public static final native int GridViewColumn_CellTemplate(int sender);
public static final native void GridViewColumn_CellTemplate(int sender, int value);
public static final native int GridViewColumn_Header(int sender);
public static final native void GridViewColumn_Header(int sender, int value);
public static final native int GridViewColumn_HeaderTemplate(int sender);
public static final native void GridViewColumn_HeaderTemplate(int sender, int value);
public static final native double GridViewColumn_Width(int sender);
public static final native void GridViewColumn_Width(int sender, double value);
public static final native int GridViewColumn_WidthProperty();
public static final native int GridViewColumnCollection_default(int sender, int index);
public static final native void GridViewColumnCollection_Clear(int sender);
public static final native int GridViewColumnCollection_Count(int sender);
public static final native int GridViewColumnCollection_IndexOf(int sender, int item);
public static final native void GridViewColumnCollection_Insert(int sender, int index, int value);
public static final native boolean GridViewColumnCollection_Remove(int sender, int value);
public static final native void GridViewColumnHeader_Content(int sender, int value);
public static final native int GridViewRowPresenterBase_ColumnsProperty();
public static final native int GridViewHeaderRowPresenter_typeid();
public static final native void GridViewRowPresenter_Content(int sender, int value);
public static final native int GridViewRowPresenter_Content(int sender);
public static final native int GridViewRowPresenter_typeid();
public static final native void GridViewRowPresenterBase_Columns(int sender, int value);
public static final native int GCHandle_Alloc(int sender);
public static final native void GCHandle_Free(int sender);
public static final native void GCHandle_Dump();
public static final native int GCHandle_ToHandle(int gchandle);
public static final native int HeaderedContentControl_Header(int sender);
public static final native void HeaderedContentControl_Header(int sender, int header);
public static final native int HeaderedItemsControl_Header(int sender);
public static final native void HeaderedItemsControl_Header(int sender, int value);  
public static final native int HeaderedItemsControl_HeaderTemplateProperty();
public static final native int HtmlDocument_InvokeScript(int sender, int string);
public static final native int HwndSource_Handle(int sender);
public static final native void Hyperlink_Click(int sender, int handler);
public static final native int ICollection_Count(int sender);
public static final native int Icon_FromHandle(int hIcon);
public static final native int IEnumerable_GetEnumerator(int sender);
public static final native int IEnumerator_Current(int sender);
public static final native boolean IEnumerator_MoveNext(int sender);
public static final native void IList_Add(int sender, int value);
public static final native void IList_Clear(int sender);
public static final native int IList_default(int sender, int index);
public static final native int IList_GetEnumerator(int sender);
public static final native int IList_IndexOf(int sender, int value);
public static final native void IList_Insert(int sender, int index, int value);
public static final native void IList_Remove(int sender, int value);
public static final native int IndexedGlyphRun_TextSourceCharacterIndex(int sender);
public static final native int IndexedGlyphRun_TextSourceLength(int sender);
public static final native int IndexedGlyphRun_GlyphRun(int sender);
public static final native int IndexedGlyphRunCollection_GetEnumerator(int sender);
public static final native int IndexedGlyphRunCollection_Current(int sender);
public static final native void InlineCollection_Add(int sender, int value);
public static final native void InlineCollection_Clear(int sender);
public static final native int InputEventArgs_Timestamp(int sender);
public static final native int Image_Source(int sender);
public static final native void Image_Source(int sender, int imageSource);
public static final native int Image_SourceProperty();
public static final native int Image_StretchProperty();
public static final native void Image_Stretch(int sender, int stretch);
public static final native int Image_typeid();
public static final native int Imaging_CreateBitmapSourceFromHIcon(int hIcon, int sourceRect, int sizeOptions);
public static final native int ImageSource_typeid();
public static final native int IntPtr_ToInt32 (int value);
public static final native void ItemCollection_Add(int sender, int item);
public static final native void ItemCollection_Clear(int sender);
public static final native int ItemCollection_Count(int sender);
public static final native int ItemCollection_CurrentItem(int sender);
public static final native int ItemCollection_CurrentPosition(int sender);
public static final native int ItemCollection_GetItemAt(int sender, int index);
public static final native int ItemCollection_IndexOf(int sender, int value);
public static final native void ItemCollection_Insert(int sender, int index, int value);
public static final native void ItemCollection_Remove(int sender, int item);
public static final native void ItemCollection_RemoveAt(int sender, int index);
public static final native boolean ItemsControl_HasItems(int sender);
public static final native int ItemsControl_Items(int sender);
public static final native void ItemsControl_ItemsSource(int sender, int value);
public static final native int ItemsControl_ItemTemplate(int sender);
public static final native void ItemsControl_ItemTemplate(int sender, int value);
public static final native void ItemsControl_IsTextSearchEnabled(int sender, boolean value);
public static final native int ItemsPresenter_typeid();
public static final native int KeyInterop_VirtualKeyFromKey(int key);
public static final native int Keyboard_FocusedElement();
public static final native int Keyboard_Focus(int element);
public static final native int Keyboard_Modifiers();
public static final native boolean KeyboardNavigation_GetIsTabStop(int element);
public static final native void KeyboardNavigation_SetIsTabStop(int element, boolean istabstop);
public static final native void KeyboardNavigation_SetDirectionalNavigation(int element, int mode);
public static final native void KeyboardNavigation_SetTabNavigation(int element, int mode);
public static final native void KeyboardNavigation_SetControlTabNavigation(int element, int mode);
public static final native int KeyboardDevice_Modifiers(int sender);
public static final native int KeyboardEventArgs_KeyboardDevice(int sender);
public static final native boolean KeyEventArgs_IsDown(int sender);
public static final native boolean KeyEventArgs_IsRepeat(int sender);
public static final native boolean KeyEventArgs_IsToggled(int sender);
public static final native int KeyEventArgs_Key(int sender);
public static final native int KeyEventArgs_SystemKey(int sender);
public static final native int KeyTime_Uniform();
public static final native boolean Matrix_IsIdentity(int sender);
public static final native void Matrix_Invert(int sender);
public static final native double Matrix_M11(int sender);
public static final native double Matrix_M12(int sender);
public static final native double Matrix_M21(int sender);
public static final native double Matrix_M22(int sender);
public static final native double Matrix_OffsetX(int sender);
public static final native double Matrix_OffsetY(int sender);
public static final native void Matrix_M11(int sender, double value);
public static final native void Matrix_M12(int sender, double value);
public static final native void Matrix_M21(int sender, double value);
public static final native void Matrix_M22(int sender, double value);
public static final native void Matrix_OffsetX(int sender, double value);
public static final native void Matrix_OffsetY(int sender, double value);
public static final native int Matrix_Multiply(int m1, int m2);
public static final native void Matrix_RotatePrepend(int sender, double angle);
public static final native void Matrix_ScalePrepend(int sender, double scaleX, double scaleY);
public static final native void Matrix_SetIdentity(int sender);
public static final native void Matrix_SkewPrepend(int sender, double skewX, double skewY);
public static final native void Matrix_TranslatePrepend(int sender, double tx, double ty);
public static final native int Matrix_Transform(int sender, int point);
public static final native int MessageBox_Show (int messageBoxText, int caption, int button, int icon,	int defaultResult);
public static final native int Mouse_Captured();
public static final native int Mouse_DirectlyOver();
public static final native int Mouse_GetPosition(int relativeTo);
public static final native boolean Mouse_SetCursor(int cursor);
public static final native int Mouse_LeftButton();
public static final native int Mouse_RightButton();
public static final native int Mouse_MiddleButton();
public static final native int Mouse_XButton1();
public static final native int Mouse_XButton2();
public static final native int MouseButtonEventArgs_ButtonState(int sender);
public static final native int MouseButtonEventArgs_ClickCount(int sender);
public static final native int MouseButtonEventArgs_ChangedButton(int sender);
public static final native int MouseEventArgs_GetPosition(int sender, int relativeTo);
public static final native int MouseEventArgs_LeftButton(int sender);
public static final native int MouseEventArgs_MiddleButton(int sender);
public static final native int MouseEventArgs_RightButton(int sender);
public static final native int MouseEventArgs_XButton1(int sender);
public static final native int MouseEventArgs_XButton2(int sender);
public static final native int MouseWheelEventArgs_Delta(int sender);
public static final native boolean ListBoxItem_IsSelected(int sender);
public static final native void ListBoxItem_IsSelected(int sender, boolean value);
public static final native void ListBox_ScrollIntoView(int sender, int value);
public static final native void ListBox_SelectAll(int sender);
public static final native int ListBox_SelectedItems(int sender);
public static final native void ListBox_SelectionMode(int sender, int value);
public static final native void ListBox_UnselectAll(int sender);
public static final native void ListView_View(int sender, int value);
public static final native int ListViewItem_typeid();
public static final native int MemoryStream_ToArray(int sender);
public static final native void MemoryStream_Write(int sender, int buffer, int offset, int count);
public static final native void Menu_IsMainMenu(int sender, boolean value);
public static final native void MenuItem_Click(int sender, int handler);
public static final native void MenuItem_Icon(int sender, int value);
public static final native void MenuItem_InputGestureText(int sender, int value);
public static final native void MenuItem_IsCheckable(int sender, boolean value);
public static final native boolean MenuItem_IsChecked(int sender);
public static final native void MenuItem_IsChecked(int sender, boolean value);
public static final native void MenuItem_SubmenuClosed(int sender, int handler);
public static final native void MenuItem_SubmenuOpened(int sender, int handler);
public static final native int Int32Rect_Empty();
public static final native int MatrixTransform_Matrix(int sender);
public static final native void MatrixTransform_Matrix(int sender, int value);
public static final native void NotifyIcon_Icon(int sender, int value);
public static final native void NotifyIcon_MouseDown(int sender, int handler);
public static final native void NotifyIcon_MouseUp(int sender, int handler);
public static final native void NotifyIcon_DoubleClick(int sender, int handler);
public static final native void NotifyIcon_Text(int sender, int value);
public static final native void NotifyIcon_Visible(int sender, boolean value);
public static final native boolean Object_Equals(int sender, int o);
public static final native int Object_GetType(int sender);
public static final native int Object_ToString(int sender);
public static final native void ObservableCollectionGridViewColumn_Move(int sender, int oldIndex, int newIndex);
public static final native void OpenFileDialog_Multiselect (int sender, boolean value);
public static final native void RowDefinition_Height(int sender, int height);
public static final native void RowDefinitionCollection_Add(int sender, int row);
public static final native int Panel_Background(int sender);
public static final native void Panel_Background(int sender, int brush);
public static final native int Panel_BackgroundProperty();
public static final native int Panel_Children(int sender);
public static final native int Panel_GetZIndex(int element);
public static final native void Panel_SetZIndex(int element, int index);
public static final native int PasswordBox_Password(int sender);
public static final native void PasswordBox_Password(int sender, int value);
public static final native char PasswordBox_PasswordChar(int sender);
public static final native void PasswordBox_PasswordChar(int sender, char value);
public static final native int PasswordBox_MaxLength(int sender);
public static final native void PasswordBox_MaxLength(int sender, int value);
public static final native void PasswordBox_PasswordChanged(int sender, int handler);
public static final native void PasswordBox_Paste(int sender);
public static final native void Path_Data(int sender, int geometry);
public static final native void Path_Fill(int sender, int brush);
public static final native void Path_Stretch(int sender, int value);
public static final native void PathFigureCollection_Add(int sender, int element);
public static final native int PathFigureCollection_Count(int sender);
public static final native void PathFigure_StartPoint(int sender, int point);
public static final native void PathFigure_IsClosed(int sender, boolean closed);
public static final native boolean PathFigure_IsClosed(int sender);
public static final native int PathFigure_Segments(int sender);
public static final native int PathFigure_Segments(int sender, int index);
public static final native void PathGeometry_AddGeometry(int sender, int geometry);
public static final native int PathGeometry_Bounds(int sender);
public static final native int PathGeometry_Clone(int sender);
public static final native void PathGeometry_FillRule(int sender, int value);
public static final native int PathGeometry_Figures(int sender);
public static final native int PathGeometry_Figures(int sender, int index);
public static final native void PathSegmentCollection_Add(int sender, int element);
public static final native int PathSegmentCollection_Count(int sender);
public static final native int Pen_Brush(int sender);
public static final native void Pen_Brush(int sender, int value);
public static final native void Pen_DashCap(int sender, int value);
public static final native void Pen_DashStyle(int sender, int value);
public static final native void Pen_EndLineCap(int sender, int value);
public static final native void Pen_StartLineCap(int sender, int value);
public static final native void Pen_LineJoin(int sender, int value);
public static final native void Pen_MiterLimit(int sender, double value);
public static final native void Pen_Thickness(int sender, double value);
public static final native int PixelFormat_BitsPerPixel(int sender);
public static final native int PixelFormats_Bgr101010();
public static final native int PixelFormats_Bgr24();
public static final native int PixelFormats_Bgr32();
public static final native int PixelFormats_Bgr555();
public static final native int PixelFormats_Bgr565();
public static final native int PixelFormats_Bgra32();
public static final native int PixelFormats_BlackWhite();
public static final native int PixelFormats_Default();
public static final native int PixelFormats_Indexed1();
public static final native int PixelFormats_Indexed2();
public static final native int PixelFormats_Indexed4();
public static final native int PixelFormats_Indexed8();
public static final native int PixelFormats_Pbgra32();
public static final native int PixelFormats_Rgb24();
public static final native void PointCollection_Add(int sender, int point);
public static final native double Point_X(int sender);
public static final native double Point_Y(int sender);
public static final native void Popup_AllowsTransparency(int sender, boolean value);
public static final native void Popup_Child(int sender, int child);
public static final native int Popup_Child(int sender);
public static final native void Popup_HorizontalOffset(int sender, double value);
public static final native double Popup_HorizontalOffset(int sender);
public static final native void Popup_IsOpen(int sender, boolean value);
public static final native boolean Popup_IsOpen(int sender);
public static final native void Popup_VerticalOffset(int sender, double value);
public static final native double Popup_VerticalOffset(int sender);
public static final native void Popup_Closed(int sender, int handler);
public static final native void Popup_Opened(int sender, int handler);
public static final native int PresentationSource_CurrentSources();
public static final native int PresentationSource_FromVisual(int visual);
public static final native int PresentationSource_RootVisual(int sender);
public static final native void ProgressBar_IsIndeterminate(int sender, boolean value);
public static final native void ProgressBar_IsIndeterminate(int sender);
public static final native void ProgressBar_Orientation(int handle, int value);
public static final native void PropertyInfo_SetValue(int sender, int obj, int value, int indexArray);
public static final native void PropertyInfo_SetValueBoolean(int sender, int obj, boolean value, int indexArray);
public static final native boolean QueryContinueDragEventArgs_EscapePressed(int sender);
public static final native void QueryContinueDragEventArgs_Action(int sender, int dragAction);
public static final native double RangeBase_LargeChange(int sender);
public static final native void RangeBase_LargeChange(int sender, double value);
public static final native double RangeBase_Maximum(int sender);
public static final native void  RangeBase_Maximum(int sender, double value);
public static final native double RangeBase_Minimum(int sender);
public static final native void  RangeBase_Minimum(int sender, double value);
public static final native double RangeBase_SmallChange(int sender);
public static final native void RangeBase_SmallChange(int sender, double value);
public static final native double RangeBase_Value(int sender);
public static final native void RangeBase_Value(int sender, double value);
public static final native void RangeBase_ValueChanged(int sender, int handler);
public static final native boolean Rect_Contains(int sender, int point);
public static final native void Rect_Intersect(int sender, int rect);
public static final native void Rect_Union(int sender, int rect);
public static final native double Rect_X(int sender);
public static final native void Rect_X(int sender, double value);
public static final native double Rect_Y(int sender);
public static final native void Rect_Y(int sender, double value);
public static final native double Rect_Width(int sender);
public static final native void Rect_Width(int sender, double value);
public static final native double Rect_Height(int sender);
public static final native void Rect_Height(int sender, double value);
public static final native int Rectangle_X(int sender);
public static final native int Rectangle_Y(int sender);
public static final native int Rectangle_Width(int sender);
public static final native int Rectangle_Height(int sender);
public static final native int Registry_ClassesRoot();
public static final native int RegistryKey_OpenSubKey(int sender, int key);
public static final native int RegistryKey_GetSubKeyNames(int sender);
public static final native int RegistryKey_GetValue(int sender, int name);
public static final native int RepeatBehavior_Forever();
public static final native void RelativeSource_AncestorType(int sender, int type);
public static final native int RenderOptions_GetBitmapScalingMode(int target);
public static final native void RenderOptions_SetBitmapScalingMode(int target, int mode);
public static final native void RenderOptions_SetEdgeMode(int target, int edgeMode);
public static final native void RenderTargetBitmap_Render(int sender, int visual);
public static final native void RoutedEventArgs_Handled(int sender, boolean handled);
public static final native int RoutedEventArgs_typeid();
public static final native int RoutedEventArgs_OriginalSource(int sender);
public static final native int RoutedEventArgs_Source(int sender);
public static final native int RoutedPropertyChangedEventArgs_NewValue(int sender);
public static final native int RoutedPropertyChangedEventArgs_OldValue(int sender);
public static final native void Run_Text(int sender, int value);
public static final native void SaveFileDialog_OverwritePrompt(int sender, boolean value);
public static final native int Screen_AllScreens();
public static final native int Screen_Bounds(int sender);
public static final native int Screen_PrimaryScreen();
public static final native int Screen_WorkingArea(int sender);
public static final native int ScrollBar_Orientation(int sender);
public static final native void ScrollBar_Orientation(int sender, int orientation);
public static final native void ScrollBar_Scroll(int sender, int handler);
public static final native double ScrollBar_ViewportSize(int sender);
public static final native void ScrollBar_ViewportSize(int sender, double value);
public static final native int ScrollBar_typeid();
public static final native int ScrollEventArgs_ScrollEventType(int sender);
public static final native void ScrollViewer_ScrollToVerticalOffset(int sender, double offset);
public static final native void ScrollViewer_SetVerticalScrollBarVisibility(int sender, int visibility);
public static final native void ScrollViewer_SetHorizontalScrollBarVisibility(int sender, int visibility);
public static final native int ScrollViewer_typeid();
public static final native double ScrollViewer_VerticalOffset(int sender);
public static final native void Selector_IsSynchronizedWithCurrentItem(int sender, boolean value);
public static final native int Selector_SelectedIndex(int sender);
public static final native void Selector_SelectedIndex(int sender, int value);
public static final native int Selector_SelectedItem(int sender);
public static final native int Selector_SelectedValue(int sender);
public static final native void Selector_SelectionChanged(int sender, int handler);
public static final native int SelectionChangedEventArgs_AddedItems(int sender);
public static final native int SelectionChangedEventArgs_RemovedItems(int sender);
public static final native void SetterBaseCollection_Add(int sender, int setter);
public static final native void Shape_Fill(int sender, int brush);
public static final native void Shape_Stroke(int sender, int brush);
public static final native void Shape_StrokeThickness(int sender, double strokethickness);
public static final native double Size_Width(int sender);
public static final native double Size_Height(int sender);
public static final native void Size_Width(int sender, double width);
public static final native void Size_Height(int sender, double height);
public static final native int SizeChangedEventArgs_NewSize(int sender);
public static final native int SizeChangedEventArgs_PreviousSize(int sender);
public static final native void Slider_Orientation(int sender, int value);
public static final native void Slider_TickFrequency(int sender, double value);
public static final native void Slider_TickPlacement(int sender, int value);
public static final native void StackPanel_Orientation(int sender, int orientation);
public static final native int StackPanel_OrientationProperty();
public static final native int StackPanel_typeid();
public static final native int StreamGeometry_Open(int sender);
public static final native void StreamGeometryContext_BeginFigure(int sender, int startPoint, boolean isFilled, boolean isClosed);
public static final native void StreamGeometryContext_Close(int sender);
public static final native void StreamGeometryContext_LineTo(int sender, int startPoint, boolean isStroked, boolean isSmoothJoin);
public static final native int String_ToCharArray(int sender);
public static final native int String_typeid();
public static final native int String_Length(int sender);
public static final native int Style_Setters(int sender);
public static final native int SWTCanvas_Visual(int sender);
public static final native void SWTCanvas_Visual(int sender, int visual);
public static final native int SWTDockPanel_JNIRefProperty();
public static final native int SWTDockPanel_typeid();
public static final native void SWTTextRunProperties_ForegroundBrush(int sender, int brush);
public static final native int SystemColors_ControlBrush();
public static final native int SystemColors_ControlColor();
public static final native int SystemColors_ControlTextBrush();
public static final native int SystemColors_ControlTextColor();
public static final native int SystemColors_ControlDarkColor();
public static final native int SystemColors_ControlLightColor();
public static final native int SystemColors_ControlLightLightColor();
public static final native int SystemColors_ControlDarkDarkColor();
public static final native int SystemColors_InfoColor();
public static final native int SystemColors_InfoTextColor();
public static final native int SystemColors_ActiveBorderColor();
public static final native int SystemColors_ActiveBorderBrush();
public static final native int SystemColors_ActiveCaptionColor();
public static final native int SystemColors_ActiveCaptionTextColor();
public static final native int SystemColors_GradientActiveCaptionColor();
public static final native int SystemColors_InactiveCaptionColor();
public static final native int SystemColors_InactiveCaptionTextColor();
public static final native int SystemColors_GradientInactiveCaptionColor();
public static final native int SystemColors_WindowColor();
public static final native int SystemColors_WindowTextColor();
public static final native int SystemColors_HighlightBrush();
public static final native int SystemColors_HighlightColor();
public static final native int SystemColors_HighlightTextColor();
public static final native int SystemFonts_MessageFontFamily();
public static final native int SystemFonts_MessageFontStyle();
public static final native double SystemParameters_MinimumHorizontalDragDistance();
public static final native double SystemParameters_MinimumVerticalDragDistance();
public static final native double SystemParameters_PrimaryScreenHeight();
public static final native double SystemParameters_PrimaryScreenWidth();
public static final native double SystemParameters_VirtualScreenLeft();
public static final native double SystemParameters_VirtualScreenTop();
public static final native double SystemParameters_VirtualScreenWidth();
public static final native double SystemParameters_VirtualScreenHeight();
public static final native double SystemParameters_VerticalScrollBarWidth();
public static final native double SystemParameters_VerticalScrollBarButtonHeight();
public static final native boolean SystemParameters_HighContrast();
public static final native double SystemParameters_HorizontalScrollBarHeight();
public static final native double SystemParameters_HorizontalScrollBarButtonWidth();
public static final native int SystemParameters_WheelScrollLines();
public static final native int SystemParameters_WorkArea();
public static final native double SystemParameters_ThinHorizontalBorderHeight();
public static final native double SystemParameters_ThinVerticalBorderWidth();
public static final native double SystemFonts_MessageFontSize();
public static final native int SystemFonts_MessageFontWeight();
public static final native void TextBlock_Background(int sender, int brush);
public static final native int TextBlock_BackgroundProperty();
public static final native int TextBlock_FontFamilyProperty();
public static final native int TextBlock_FontStyleProperty();
public static final native int TextBlock_FontWeightProperty();
public static final native int TextBlock_FontStretchProperty();
public static final native int TextBlock_FontSizeProperty();
public static final native void TextBlock_FontFamily(int sender, int value);
public static final native void TextBlock_FontStyle(int sender, int value);
public static final native void TextBlock_FontWeight(int sender, int value);
public static final native void TextBlock_FontStretch(int sender, int value);
public static final native void TextBlock_FontSize(int sender, double value);
public static final native void TextBlock_Foreground(int sender, int brush);
public static final native int TextBlock_ForegroundProperty();
public static final native int TextBounds_Rectangle(int sender);
public static final native int TextBoundsCollection_GetEnumerator(int sender);
public static final native int TextBoundsCollection_Current(int sender);
public static final native void TextTabPropertiesCollection_Add(int sender, int tab);
public static final native void TabControl_TabStripPlacement(int sender, int value);
public static final native boolean TabItem_IsSelected(int sender);
public static final native int TextBlock_Inlines(int sender);
public static final native int TextBlock_Text(int sender);
public static final native void TextBlock_Text(int sender, int str);
public static final native int TextBlock_TextProperty();
public static final native int TextBlock_typeid();
public static final native int TextBox_CaretIndex(int sender);
public static final native void TextBox_CaretIndex(int sender, int value);
public static final native int TextBox_GetFirstVisibleLineIndex(int sender);
public static final native int TextBox_GetLineIndexFromCharacterIndex(int sender, int value);
public static final native int TextBox_GetRectFromCharacterIndex(int sender, int value);
public static final native int TextBox_LineCount(int sender);
public static final native int TextBox_MaxLength(int sender);
public static final native void TextBox_MaxLength(int sender, int value);
public static final native void TextBox_ScrollToLine(int sender, int value);
public static final native void TextBox_Select(int sender, int start, int length);
public static final native int TextBox_SelectedText(int sender);
public static final native void TextBox_SelectedText(int sender, int value);
public static final native int TextBox_SelectionLength(int sender);
public static final native void TextBox_SelectionLength(int sender, int value);
public static final native int TextBox_SelectionStart(int sender);
public static final native void TextBox_SelectionStart(int sender, int value);
public static final native int TextBox_Text(int sender);
public static final native void TextBox_Text(int sender, int value);
public static final native void TextBox_TextWrapping(int sender, int value);
public static final native void TextBoxBase_AcceptsReturn(int sender, boolean value);
public static final native void TextBoxBase_AcceptsTab(int sender, boolean value);
public static final native void TextBoxBase_AppendText(int sender, int value);
public static final native void TextBoxBase_Copy(int sender);
public static final native void TextBoxBase_HorizontalScrollBarVisibility(int sender, int value);
public static final native void TextBoxBase_Cut(int sender);
public static final native boolean TextBoxBase_IsReadOnly(int sender);
public static final native void TextBoxBase_IsReadOnly(int sender, boolean value);
public static final native void TextBoxBase_Paste(int sender);
public static final native void TextBoxBase_ScrollToEnd(int sender);
public static final native void TextBoxBase_ScrollToVerticalOffset(int sender, double value);
public static final native void TextBoxBase_SelectAll(int sender);
public static final native void TextBoxBase_TextChanged(int sender, int handler);
public static final native double TextBoxBase_VerticalOffset(int sender);
public static final native void TextBoxBase_VerticalScrollBarVisibility(int sender, int value);
public static final native int TextCompositionEventArgs_ControlText(int sender);
public static final native void TextCompositionEventArgs_Handled(int sender, boolean value);
public static final native int TextCompositionEventArgs_SystemText(int sender);
public static final native int TextCompositionEventArgs_Text(int sender);
public static final native int TextDecorations_Underline();
public static final native int TextDecorations_Strikethrough();
public static final native void TextDecorationCollection_Add(int sender, int decoration); 
public static final native int TextFormatter_Create();
public static final native int TextFormatter_FormatLine(int sender, int textSource, int firstCharIndex, double paragraphWidth, int paragraphProperties, int previousLineBreak);
public static final native double TextLine_Baseline(int sender);
public static final native double TextLine_Height(int sender);
public static final native int TextLine_NewlineLength(int sender);
public static final native int TextLine_GetNextCaretCharacterHit(int sender, int characterHit);
public static final native int TextLine_GetPreviousCaretCharacterHit(int sender, int characterHit);
public static final native int TextLine_GetTextLineBreak(int sender);
public static final native int TextLine_GetTextBounds(int sender, int firstTextSourceCharacterIndex, int textLength);
public static final native int TextLine_GetCharacterHitFromDistance(int sender, double distance);
public static final native int TextLine_GetIndexedGlyphRuns(int sender);
public static final native double TextLine_GetDistanceFromCharacterHit(int sender, int characterHit);
public static final native int TextLine_Length(int sender);
public static final native double TextLine_Start(int sender);
public static final native double TextLine_Width(int sender);
public static final native double TextLine_WidthIncludingTrailingWhitespace(int sender);
public static final native void TextLine_Draw(int sender, int drawContext, int origin, int invertAxes);
public static final native double Thickness_Left(int sender);
public static final native double Thickness_Right(int sender);
public static final native double Thickness_Top(int sender);
public static final native double Thickness_Bottom(int sender);
public static final native int Thumb_DragDeltaEvent();
public static final native void TileBrush_TileMode(int sender, int mode);
public static final native void TileBrush_Stretch(int sender, int stretch);
public static final native void TileBrush_Viewport(int sender, int viewport);
public static final native void TileBrush_ViewportUnits(int sender, int mode);
public static final native void TileBrush_AlignmentX(int sender, int value);
public static final native void TileBrush_AlignmentY(int sender, int value);
public static final native void Timeline_AutoReverse(int sender, boolean autoReverse);
public static final native void Timeline_Duration(int sender, int duration);
public static final native void Timeline_RepeatBehavior(int sender, int behavior);
public static final native int TimeSpan_FromMilliseconds(double ms);
public static final native void ToggleButton_Checked(int sender, int handler);
public static final native int ToggleButton_CheckedEvent();
public static final native int ToggleButton_IndeterminateEvent ();
public static final native boolean ToggleButton_IsChecked(int sender);
public static final native void ToggleButton_IsChecked(int sender, boolean value);
public static final native void ToggleButton_IsCheckedNullSetter(int sender);
public static final native int ToggleButton_IsCheckedProperty();
public static final native int ToggleButton_IsThreeStateProperty();
public static final native void ToggleButton_Unchecked(int sender, int handler);
public static final native int ToggleButton_UncheckedEvent();
public static final native int ToolBar_Band(int sender);
public static final native void ToolBar_Band(int sender, int value);
public static final native int ToolBar_BandIndex(int sender);
public static final native void ToolBar_BandIndex(int sender, int value);
public static final native int ToolBar_BandProperty();
public static final native int ToolBar_ButtonStyleKey();
public static final native int ToolBar_CheckBoxStyleKey();
public static final native int ToolBar_RadioButtonStyleKey();
public static final native int ToolBar_SeparatorStyleKey();
public static final native boolean ToolBar_HasOverflowItems(int sender);
public static final native void ToolBar_SetOverflowMode(int element, int mode);
public static final native int ToolBar_typeid();
public static final native void ToolBarTray_Background(int sender, int value);
public static final native boolean ToolBarTray_IsLocked(int sender);
public static final native void ToolBarTray_IsLocked(int sender, boolean value);
public static final native void ToolBarTray_Orientation(int sender, int value);
public static final native int ToolBarTray_ToolBars(int sender);
public static final native void TransformCollection_Add(int sender, int transform);
public static final native int Transform_Clone(int sender);
public static final native int TransformGroup_Children(int sender);
public static final native int TreeView_SelectedItem(int sender);
public static final native void TreeView_SelectedItemChanged(int sender, int handler);
public static final native int TreeView_typeid();
public static final native int TreeViewItem_CollapsedEvent();
public static final native int TreeViewItem_ExpandedEvent();
public static final native boolean TreeViewItem_IsExpanded(int sender);
public static final native void TreeViewItem_IsExpanded(int sender, boolean value);
public static final native boolean TreeViewItem_IsSelected(int sender);
public static final native void TreeViewItem_IsSelected(int sender, boolean value);
public static final native int TreeViewItem_HeaderTemplate(int sender);
public static final native void TreeViewItem_HeaderTemplate(int sender, int value);
public static final native int TreeViewItem_HeaderTemplateProperty();
public static final native int TreeViewItem_typeid();
public static final native int Type_GetProperty(int sender, int name, int bindingFlags);
public static final native int TypeConverter_ConvertFromString(int sender, int string);
public static final native int TypeConverter_ConvertToString(int sender, int object);
public static final native int TypeDescriptor_GetConverter(int object);
public static final native int Typeface_FontFamily(int sender);
public static final native int Typeface_Style(int sender);
public static final native int Typeface_Weight(int sender);
public static final native int Typeface_Stretch(int sender);
public static final native int TypefaceCollection_Count(int sender);
public static final native int TypefaceCollection_Current(int sender);
public static final native int TypefaceCollection_GetEnumerator(int sender);
public static final native boolean Type_IsInstanceOfType(int sender, int object);
public static final native int Type_FullName(int sender);
public static final native int UIElementCollection_default(int sender, int index);
public static final native void UIElementCollection_Add(int sender, int child);
public static final native void UIElementCollection_Insert(int sender, int index, int child);
public static final native int UIElementCollection_IndexOf(int sender, int child);
public static final native boolean UIElementCollection_Contains(int sender, int child);
public static final native void UIElementCollection_Clear(int sender);
public static final native int UIElementCollection_Count(int sender);
public static final native int UIElementCollection_Current(int sender);
public static final native int UIElementCollection_GetEnumerator(int sender);
public static final native void UIElementCollection_Remove(int sender, int child);
public static final native void UIElement_AddHandler(int sender, int event, int handler, boolean handledEventsToo);
public static final native void UIElement_AllowDrop(int sender, boolean value);
public static final native boolean UIElement_CaptureMouse(int sender);
public static final native void UIElement_Clip(int sender, int geometry);
public static final native void UIElement_ClipToBounds(int sender, boolean value);
public static final native int UIElement_ClipToBoundsProperty();
public static final native void UIElement_DragEnter(int sender, int handler);
public static final native int UIElement_DragEnterEvent();
public static final native void UIElement_DragLeave(int sender, int handler);
public static final native int UIElement_DragLeaveEvent();
public static final native void UIElement_DragOver(int sender, int handler);
public static final native int UIElement_DragOverEvent();
public static final native void UIElement_Drop(int sender, int handler);
public static final native int UIElement_DropEvent();
public static final native boolean UIElement_Focus(int sender);
public static final native void UIElement_Focusable (int sender, boolean value);
public static final native void UIElement_BeginAnimation(int sender, int dp, int animation);
public static final native int UIElement_InputHitTest(int sender, int point);
public static final native void UIElement_InvalidateVisual(int sender);
public static final native boolean UIElement_IsEnabled(int sender);
public static final native void UIElement_IsEnabled(int sender, boolean enable);
public static final native boolean UIElement_IsFocused(int sender);
public static final native void UIElement_IsHitTestVisible(int sender, boolean value);
public static final native boolean UIElement_IsKeyboardFocused(int sender); 
public static final native boolean UIElement_IsKeyboardFocusWithin(int sender);
public static final native boolean UIElement_IsMeasureValid(int sender);
public static final native boolean UIElement_IsMouseOver(int sender);
public static final native boolean UIElement_IsVisible(int sender);
public static final native void UIElement_KeyUp(int sender, int handler);
public static final native void UIElement_KeyDown(int sender, int handler);
public static final native int UIElement_DesiredSize(int sender);
public static final native void UIElement_GiveFeedback(int sender, int handler);
public static final native int UIElement_GiveFeedbackEvent();
public static final native void UIElement_LayoutUpdated(int sender, int handler);
public static final native void UIElement_Measure(int sender, int availableSize);
public static final native void UIElement_MouseDown(int sender, int handler);
public static final native void UIElement_MouseEnter(int sender, int handler);
public static final native void UIElement_MouseLeave(int sender, int handler);
public static final native void UIElement_MouseMove(int sender, int handler);
public static final native void UIElement_MouseWheel(int sender, int handler);
public static final native void UIElement_MouseUp(int sender, int handler);
public static final native void UIElement_MoveFocus(int sender, int request);
public static final native double UIElement_Opacity(int sender);
public static final native void UIElement_Opacity(int sender, double value);
public static final native int UIElement_OpacityProperty();
public static final native void UIElement_PreviewKeyDown(int sender, int handler);
public static final native void UIElement_PreviewKeyUp(int sender, int handler);
public static final native void UIElement_PreviewMouseDown(int sender, int handler);
public static final native void UIElement_PreviewMouseMove(int sender, int handler);
public static final native void UIElement_PreviewMouseWheel(int sender, int handler);
public static final native void UIElement_PreviewMouseUp(int sender, int handler);
public static final native void UIElement_PreviewGotKeyboardFocus(int sender, int handler);
public static final native void UIElement_PreviewLostKeyboardFocus(int sender, int handler);
public static final native void UIElement_LostKeyboardFocus(int sender, int handler);
public static final native void UIElement_PreviewTextInput(int sender, int handler);
public static final native void UIElement_QueryContinueDrag(int sender, int handler);
public static final native int UIElement_QueryContinueDragEvent();
public static final native int UIElement_RenderSize(int sender);
public static final native void UIElement_ReleaseMouseCapture(int sender);
public static final native void UIElement_RemoveHandler(int sender, int routedEvent, int handler);
public static final native void UIElement_SnapsToDevicePixels(int sender, boolean value);
public static final native void UIElement_TextInput(int sender, int handler);
public static final native int UIElement_TranslatePoint(int sender, int point, int relativeTo);
public static final native void UIElement_UpdateLayout(int sender);
public static final native byte UIElement_Visibility(int sender);
public static final native void UIElement_Visibility(int sender, byte visible);
public static final native int UIElement_VisibilityProperty();
public static final native double VirtualizingStackPanel_VerticalOffset(int sender);
public static final native boolean Visual_IsAncestorOf(int sender, int descendant);
public static final native boolean Visual_IsDescendantOf(int sender, int ancestor);
public static final native int Visual_PointToScreen(int sender, int point);
public static final native int Visual_PointFromScreen(int sender, int point);
public static final native int VisualTreeHelper_GetChild(int sender, int value);
public static final native int VisualTreeHelper_GetChildrenCount(int sender);
public static final native int VisualTreeHelper_GetParent(int sender);
public static final native boolean WebBrowser_CanGoBack(int sender);
public static final native boolean WebBrowser_CanGoForward(int sender);
public static final native int WebBrowser_Document(int sender);
public static final native int WebBrowser_DocumentText(int sender);
public static final native void WebBrowser_DocumentText(int sender, int string);
public static final native int WebBrowser_DocumentTitle(int sender);
public static final native void WebBrowser_DocumentCompleted(int sender, int handler);
public static final native boolean WebBrowser_GoBack(int sender);
public static final native boolean WebBrowser_GoForward(int sender);
public static final native void WebBrowser_Navigating(int sender, int handler);
public static final native void WebBrowser_Navigated(int sender, int handler);
public static final native void WebBrowser_Navigate(int sender, int urlString);
public static final native void WebBrowser_ProgressChanged(int sender, int handler);
public static final native void WebBrowser_DocumentTitleChanged(int sender, int handler);
public static final native int WebBrowser_StatusText(int sender);
public static final native void WebBrowser_StatusTextChanged(int sender, int handler);
public static final native int WebBrowser_ReadyState(int sender);
public static final native void WebBrowser_Refresh(int sender);
public static final native void WebBrowser_Stop(int sender);
public static final native void WebBrowser_ScriptErrorsSuppressed(int sender, boolean value);
public static final native int WebBrowser_Url(int sender);
public static final native int WebBrowserNavigatingEventArgs_Url(int sender);
public static final native int WebBrowserNavigatedEventArgs_Url(int sender);
public static final native int WebBrowserDocumentCompletedEventArgs_Url(int sender);
public static final native long WebBrowserProgressChangedEventArgs_CurrentProgress(int sender);
public static final native long WebBrowserProgressChangedEventArgs_MaximumProgress(int sender);
public static final native int WindowCollection_Count(int sender);
public static final native int WindowCollection_Current(int sender);
public static final native int WindowCollection_GetEnumerator(int sender);
public static final native void Window_Activate(int sender);
public static final native void Window_Close(int sender);
public static final native void Window_Closing(int sender, int handler);
public static final native void Window_Activated(int sender, int handler);
public static final native void Window_Deactivated(int sender, int handler);
public static final native void Window_LocationChanged(int sender, int handler);
public static final native int Window_GetWindow(int dependencyObject);
public static final native void Window_Hide(int sender);
public static final native void Window_Owner(int sender, int owner);
public static final native void Window_Show(int sender);
public static final native double Window_Left(int sender);
public static final native double Window_Top(int sender);
public static final native void Window_Left(int sender, double left);
public static final native void Window_Top(int sender, double top);
public static final native void Window_Icon(int sender, int icon);
public static final native boolean Window_IsActive(int sender);
public static final native int Window_WindowState (int sender);
public static final native void Window_WindowState (int sender, int windowState);
public static final native void Window_AllowsTransparency(int sender, boolean value);
public static final native int Window_WindowStyle(int sender);
public static final native void Window_WindowStyle(int sender, int value);
public static final native void Window_ShowInTaskbar(int sender, boolean value);
public static final native void Window_ResizeMode(int sender, int value);
public static final native int Window_Title(int sender);
public static final native void Window_Title(int sender, int string);
public static final native void WindowsFormsHost_Child(int sender, int child);
public static final native void WriteableBitmap_WritePixels(int sender, int sourceRect, byte[] buffer, int bufferSize, int stride);

public static final native int gcnew_AccessText();
public static final native int gcnew_Application();
public static final native int gcnew_ArrayList(int count);
public static final native int gcnew_ArcSegment(int point, int size,  double rotationAngle, boolean isLargeArc, int sweepDirection, boolean isStroked);
public static final native int gcnew_BitmapImage();
public static final native int gcnew_BezierSegment(int point1, int point2, int point3, boolean isScrolled);
public static final native int gcnew_Binding(int propertyPath);
public static final native int gcnew_BitmapPalette(int colors);
public static final native int gcnew_Bitmap(int width, int height, int stride, int format, byte[] scan0);
public static final native int gcnew_Button();
public static final native int gcnew_Canvas();
public static final native int gcnew_CheckBox();
public static final native int gcnew_ColorDialog();
public static final native int gcnew_ColorList(int count);
public static final native int gcnew_ComboBox();
public static final native int gcnew_ComboBoxItem();
public static final native int gcnew_ControlTemplate();
public static final native int gcnew_CroppedBitmap(int source, int sourceRect);
public static final native int gcnew_CharacterHit(int firstCharacterIndex, int trailingLength);
public static final native int gcnew_CombinedGeometry(int geometryCombineMode, int geometry1, int geometry2); 
public static final native int gcnew_CompositeCollection();
public static final native int gcnew_ContextMenu();
public static final native int gcnew_ContentControl(); 
public static final native int gcnew_ColumnDefinition();
public static final native int gcnew_DrawingVisual();
public static final native int gcnew_DoubleAnimationUsingKeyFrames();
public static final native int gcnew_DashStyle(int dashes, double offset);
public static final native int gcnew_DataObject();
public static final native int gcnew_DataTemplate();
public static final native int gcnew_DispatcherFrame();
public static final native int gcnew_DispatcherTimer();
public static final native int gcnew_DiscreteDoubleKeyFrame(double value, int keytime);
public static final native int gcnew_DoubleCollection(int capacity);
public static final native int gcnew_Duration(int timespan);
public static final native int gcnew_Expander();
public static final native int gcnew_EllipseGeometry(int rect);
public static final native int gcnew_FileInfo(int path);
public static final native int gcnew_FolderBrowserDialog();
public static final native int gcnew_Font(int fontFamily, float size, int fontStyle);
public static final native int gcnew_FontDialog();
public static final native int gcnew_FontFamily(int str);
public static final native int gcnew_FormatConvertedBitmap(int source, int destinationFormat, int destinationPalette, double alphaThreshold);
public static final native int gcnew_FormattedText(int string, int culture, int flowDirection, int typeface, double emSize, int brush);
public static final native int gcnew_Frame();
public static final native int gcnew_FrameworkElementFactory(int type);
public static final native int gcnew_FrameworkElementFactory(int type, int name);
public static final native int gcnew_GeometryGroup();
public static final native int gcnew_Grid();
public static final native int gcnew_GridLength(double value, int type);
public static final native int gcnew_GridView();
public static final native int gcnew_GridViewColumn();
public static final native int gcnew_GridViewColumnCollection();
public static final native int gcnew_GridViewColumnHeader();
public static final native int gcnew_GroupBox();
public static final native int gcnew_Hyperlink(int inline);
//public static final native int gcnew_Icon(int stream);
public static final native int gcnew_ImageBrush(int imageSource);
public static final native int gcnew_Image();
public static final native int gcnew_Int32(int value);
public static final native int gcnew_Int32Rect(int x, int y, int width, int height);
public static final native int gcnew_IntPtr(int value);
public static final native int gcnew_Label();
public static final native int gcnew_LinearGradientBrush(int startColor, int endColor, double angle);
public static final native int gcnew_LinearGradientBrush(int startColor, int endColor, int startPoint, int endPonit);
public static final native int gcnew_LineSegment(int point, boolean isStroked);
public static final native int gcnew_ListBox();
public static final native int gcnew_ListBoxItem();
public static final native int gcnew_ListView();
public static final native int gcnew_ListViewItem();
public static final native int gcnew_Matrix(double m11, double m12, double m21, double m22, double offsetX, double offsetY);
public static final native int gcnew_MatrixTransform(int matrix);
public static final native int gcnew_MemoryStream();
public static final native int gcnew_Menu();
public static final native int gcnew_MenuItem();
public static final native int gcnew_NotifyIcon();
public static final native int gcnew_OpenFileDialog();
public static final native int gcnew_PasswordBox();
public static final native int gcnew_Path();
public static final native int gcnew_PathFigure();
public static final native int gcnew_PathGeometry();
public static final native int gcnew_Pen();
public static final native int gcnew_Pen(int brush, double thickness);
public static final native int gcnew_PolyLineSegment(int points, boolean isStroked);
public static final native int gcnew_PointCollection(int capacity);
public static final native int gcnew_Point(double x, double y);
public static final native int gcnew_Popup();
public static final native int gcnew_ProgressBar();
public static final native int gcnew_QuadraticBezierSegment(int point1, int point2, boolean isScrolled);
public static final native int gcnew_RadioButton();
public static final native int gcnew_Rect(double x, double y, double width, double height);
public static final native int gcnew_RectangleGeometry(int rect);
public static final native int gcnew_RelativeSource(int relativeSourceMode);
public static final native int gcnew_RenderTargetBitmap(int pixelWidth, int pixelHeight, double dpiX, double dpiY, int pixelFormat);
public static final native int gcnew_RepeatBehavior(int repeatCount);
public static final native int gcnew_RepeatButton();
public static final native int gcnew_Rectangle();
public static final native int gcnew_RowDefinition();
public static final native int gcnew_Run();
public static final native int gcnew_SaveFileDialog();
public static final native int gcnew_ScrollBar();
public static final native int gcnew_ScrollViewer();
public static final native int gcnew_Separator();
public static final native int gcnew_Setter(int dp, int value);
public static final native int gcnew_SetterVisibility(int dp, int value);
public static final native int gcnew_Size();
public static final native int gcnew_Size(double width, double height);
public static final native int gcnew_Slider();
public static final native int gcnew_ScaleTransform(double scaleX, double scaleY);
public static final native int gcnew_SolidColorBrush(int color);
public static final native int gcnew_StackPanel();
public static final native int gcnew_StreamGeometry();
public static final native int gcnew_String(char[] value);
public static final native int gcnew_String(char[] value, int startIndex, int length);
public static final native int gcnew_Style();
public static final native int gcnew_SWTCanvas(int jniRef);
public static final native int gcnew_SWTSafeHandle(int handle, boolean isIcon);
//public static final native int gcnew_SWTDockPanel(int jniRef);
public static final native int gcnew_SWTTextSource(int jniRef);
public static final native int gcnew_SWTTextEmbeddedObject(int properties, int lenght, double width, double height, double baseline);
public static final native int gcnew_SWTTextRunProperties(int typeface, double size, double hittingSize, int textDecorations, int foregroundBrush, int backgroundBrush, int baselineAlignment, int culture);
public static final native int gcnew_SWTTextParagraphProperties(int flowDirection, int textAlignment, boolean firstLineInParagraph, int defaultTextRunProperties, int textWrap, double lineHeight, double indent, int tabs);
public static final native int gcnew_SWTTreeView(int jniRef);
public static final native int gcnew_SWTTreeViewRowPresenter(int treeView);
public static final native int gcnew_TabControl();
public static final native int gcnew_TabItem();
public static final native int gcnew_TemplateBindingExtension(int dp);
public static final native int gcnew_TextDecorationCollection(int capacity); 
public static final native int gcnew_TextDecoration(int location, int pen, double penOffset, int penOffsetUnit, int penThicknessUnit);
public static final native int gcnew_TextTabProperties(int alignment, double location, int tabLeader, int aligningChar);
public static final native int gcnew_TextTabPropertiesCollection(int capacity);
public static final native int gcnew_TextBlock();
public static final native int gcnew_TextBox();
public static final native int gcnew_TextCharacters(int string, int offsetToFirstChar, int length, int textRunProperties);
public static final native int gcnew_TextEndOfLine(int length, int textRunProperties);
public static final native int gcnew_TextEndOfParagraph(int length, int textRunProperties);
public static final native int gcnew_TiffBitmapEncoder();
public static final native int gcnew_TimeSpan(long ticks);
public static final native int gcnew_Thickness(double left, double top, double right, double bottom);
public static final native int gcnew_ToggleButton();
public static final native int gcnew_ToolBar();
public static final native int gcnew_ToolBarTray();
public static final native int gcnew_TransformGroup();
public static final native int gcnew_TranslateTransform(double offsetX, double offsetY);
public static final native int gcnew_TraversalRequest(int direction);
public static final native int gcnew_TreeView();
public static final native int gcnew_TreeViewItem();
public static final native int gcnew_Typeface(int fontFamily, int style, int weight, int stretch);
public static final native int gcnew_UserControl();
public static final native int gcnew_Uri(int str, int type);
public static final native int gcnew_WebBrowser();
public static final native int gcnew_WindowsFormsHost();
public static final native int gcnew_Window();
public static final native int gcnew_WriteableBitmap (int source);
public static final native int gcnew_WriteableBitmap (int pixelWidth, int pixelHeight, double dpiX, double dpiY, int pixelFormat, int palette);
public static final native void memcpy(char[] dest, int src, int size);
public static final native void memcpy(byte[] dest, int src, int size);
public static final native void memcpy(int src, byte[] dest, int size);


//Demo
public static final native int FrameworkElement_Resources(int sender);
public static final native void FrameworkElement_Resources(int sender, int value);
public static final native int gcnew_StringReader(int string);
public static final native int XmlReader_Create(int stream);
public static final native int XamlReader_Load(int stream);
public static final native int gcnew_ResourceDictionary();
public static final native void ResourceDictionary_Source(int sender, int uri);



public static final native int gcnew_DiscreteDoubleKeyFrame();
public static final native int gcnew_LinearDoubleKeyFrame();
public static final native int gcnew_PropertyPath(int parameter);
public static final native int gcnew_SplineDoubleKeyFrame();
public static final native int gcnew_Storyboard();
public static final native int gcnew_SWTAnimator(int jniRef);
public static final native void DoubleKeyFrame_Value(int sender, double value);
public static final native void DoubleKeyFrame_KeyTime(int sender, int value);
public static final native int KeyTime_FromTimeSpan(int timeSpan);
public static final native void Storyboard_Begin(int sender, int containingObject, boolean isControllable);
public static final native void Storyboard_Pause(int sender, int containingObject);
public static final native void Storyboard_Resume(int sender, int containingObject);
public static final native void Storyboard_Stop(int sender, int containingObject);
public static final native int TimelineGroup_Children(int sender);
public static final native int SWTAnimator_DoubleValueProperty();
public static final native int SWTAnimator_IntValueProperty();
public static final native void FrameworkElement_RegisterName(int sender, int name, int scopedElement);
public static final native double DependencyPropertyChangedEventArgs_NewValueDouble(int sender);
public static final native double DependencyPropertyChangedEventArgs_OldValueDouble(int sender);
public static final native int DependencyPropertyChangedEventArgs_NewValueInt(int sender);
public static final native int DependencyPropertyChangedEventArgs_OldValueInt(int sender);
public static final native void Storyboard_SetTargetName(int element, int name);
public static final native void Storyboard_SetTargetProperty(int element, int propertyPath);
public static final native int gcnew_NameScope();
public static final native int NameScope_GetNameScope(int dependencyObject);
public static final native void NameScope_SetNameScope(int dependencyObject, int nameScope);
public static final native int gcnew_KeySpline(double x1, double y1, double x2, double y2);
public static final native void SplineDoubleKeyFrame_KeySpline(int sender, int value);
public static final native void Timeline_Completed(int sender, int handler);
public static final native int gcnew_Int32AnimationUsingKeyFrames();
public static final native int gcnew_DiscreteInt32KeyFrame();
public static final native int gcnew_LinearInt32KeyFrame();
public static final native int gcnew_SplineInt32KeyFrame();
public static final native int Int32AnimationUsingKeyFrames_KeyFrames(int sender);
public static final native void Int32KeyFrame_Value(int sender, int value);
public static final native void SplineInt32KeyFrame_KeySpline(int sender, int value);
public static final native void Int32KeyFrame_KeyTime(int sender, int value);

public static final native int Timeline_Duration(int sender);
public static final native int Duration_TimeSpan(int sender);
public static final native double TimeSpan_TotalMilliseconds(int sender);
public static final native int Timeline_BeginTime(int sender);

public static final native int gcnew_OuterGlowBitmapEffect();
public static final native int OuterGlowBitmapEffect_GlowColor(int sender);
public static final native void OuterGlowBitmapEffect_GlowColor(int sender, int value);
public static final native double OuterGlowBitmapEffect_GlowSize(int sender);
public static final native void OuterGlowBitmapEffect_GlowSize(int sender, double value);
public static final native double OuterGlowBitmapEffect_Opacity(int sender);
public static final native void OuterGlowBitmapEffect_Opacity(int sender, double value);
public static final native int UIElement_BitmapEffect(int sender);
public static final native void UIElement_BitmapEffect(int sender, int value);
public static final native int gcnew_DropShadowBitmapEffect();
public static final native int DropShadowBitmapEffect_Color(int sender);
public static final native void DropShadowBitmapEffect_Color(int sender, int value);
public static final native double DropShadowBitmapEffect_Direction(int sender);
public static final native void DropShadowBitmapEffect_Direction(int sender, double value);
public static final native double DropShadowBitmapEffect_Opacity(int sender);
public static final native void DropShadowBitmapEffect_Opacity(int sender, double value);
public static final native double DropShadowBitmapEffect_ShadowDepth(int sender);
public static final native void DropShadowBitmapEffect_ShadowDepth(int sender, double value);
public static final native double DropShadowBitmapEffect_Softness(int sender);
public static final native void DropShadowBitmapEffect_Softness(int sender, double value);
public static final native int gcnew_BlurBitmapEffect();
public static final native void BlurBitmapEffect_Radius(int sender, double value);
public static final native double BlurBitmapEffect_Radius(int sender);
public static final native int gcnew_BevelBitmapEffect();
public static final native double BevelBitmapEffect_LightAngle(int handle);
public static final native void BevelBitmapEffect_LightAngle(int handle, double value);
public static final native double BevelBitmapEffect_BevelWidth(int handle);
public static final native void BevelBitmapEffect_BevelWidth(int handle, double value);
public static final native double BevelBitmapEffect_Smoothness(int handle);
public static final native void BevelBitmapEffect_Smoothness(int handle, double value);
public static final native int gcnew_BitmapEffectGroup();
public static final native int BitmapEffectGroup_Children(int sender);

public static final native int HwndSource_CompositionTarget(int sender);
public static final native void HwndTarget_BackgroundColor(int sender, int value);

public static final native int TypeDescriptor_GetProperties(int sender);
public static final native int MemberDescriptor_Name(int sender);
public static final native int DependencyPropertyDescriptor_DependencyProperty(int sender);
public static final native int DependencyPropertyDescriptor_typeid();
public static final native int DependencyPropertyDescriptor_FromProperty(int propertyDescriptor);
public static final native int Type_GetType(int typeName, boolean throwOnError, boolean ignoreCase);
public static final native void NameScope_RegisterName(int sender, int name, int scopedElement);

public static final native int Panel_HeightProperty();
public static final native int Panel_WidthProperty();
public static final native int Canvas_TopProperty();
public static final native int Canvas_LeftProperty();
public static final native int OuterGlowBitmapEffect_GlowSizeProperty();
public static final native int gcnew_Int32Animation();
public static final native int gcnew_DoubleAnimation();
public static final native void Timeline_BeginTime(int sender, int value);
public static final native void DoubleAnimation_To(int sender, double value);
public static final native double DoubleAnimation_To(int sender);
public static final native void Int32Animation_To(int sender, int value);
public static final native int Int32Animation_To(int sender);
public static final native void DoubleAnimation_From(int sender, double value);
public static final native double DoubleAnimation_From(int sender);
public static final native void Int32Animation_From(int sender, int value);
public static final native int Int32Animation_From(int sender);
public static final native void Timeline_DecelerationRatio(int sender, double value);
public static final native double Timeline_DecelerationRatio(int sender);
public static final native void Timeline_AccelerationRatio(int sender, double value);
public static final native double Timeline_AccelerationRatio(int sender);

public static final native int gcnew_SWTAnimation(int jniRef);
public static final native int Type_GetMethod(int sender, int name, int bindingFlags);
public static final native int ArrayList_ToArray(int sender);
public static final native int MethodInfo_Invoke(int sender, int obj, int parameters);
}