// Copyright (c) 1995-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of the License "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// e32test\math\t_float1.cpp
// File for T_FLOAT.CPP containing data for test1
// T_FLOAT.CPP split into header files because there seems to be too much static data for GCC
// compiler
// 
//

#include "t_float.h"

GLDEF_D RtoB_TEST testd[]=
    {
	// GENERAL format limited to 12 significant digits 
	// No triads, no three-digit exponents and no extra space for sign
    RtoB_TEST(1.23456789012501,generalLimit,32,15,'.',',',3,_S("1.23456789013")),
    RtoB_TEST(1.2345678901249,generalLimit,32,15,'.',',',3,_S("1.23456789012")),
    RtoB_TEST(1.99999999996,generalLimit,32,15,'.',',',3,_S("1.99999999996")),
    RtoB_TEST(1.999999999996,generalLimit,32,15,'.',',',3,_S("2")),
    RtoB_TEST(1.9999999999996,generalLimit,32,15,'.',',',3,_S("2")),
    RtoB_TEST(1.99999999999996,generalLimit,32,15,'.',',',3,_S("2")),
    RtoB_TEST(1.99999999994,generalLimit,32,15,'.',',',3,_S("1.99999999994")),
    RtoB_TEST(1.999999999994,generalLimit,32,15,'.',',',3,_S("1.99999999999")),
    RtoB_TEST(1.9999999999994,generalLimit,32,15,'.',',',3,_S("2")),
    RtoB_TEST(1.99999999999994,generalLimit,32,15,'.',',',3,_S("2")),
    RtoB_TEST(1.99999999996E2,generalLimit,32,15,'.',',',3,_S("199.999999996")),
    RtoB_TEST(1.999999999996E-2,generalLimit,32,15,'.',',',3,_S("0.02")),
    RtoB_TEST(1.9999999999996E2,generalLimit,32,15,'.',',',3,_S("200")),
    RtoB_TEST(1.99999999999996E-2,generalLimit,32,15,'.',',',3,_S("0.02")),
    RtoB_TEST(1.99999999994E2,generalLimit,32,15,'.',',',3,_S("199.999999994")),
    RtoB_TEST(1.999999999994E-2,generalLimit,32,15,'.',',',3,_S("0.0199999999999")),
    RtoB_TEST(1.9999999999994E99,generalLimit,32,15,'.',',',3,_S("2E+99")),
    RtoB_TEST(1.99999999999994E-99,generalLimit,32,15,'.',',',3,_S("2E-99")),
    RtoB_TEST(0.0,generalLimit,32,15,'.',',',3,_S("0")),
 	//
    RtoB_TEST(1.2E+99,generalLimit,8,15,'.','0',0,_S("1.2E+99")),
    RtoB_TEST(1.2E-99,generalLimit,8,15,'.','0',0,_S("1.2E-99")),
    RtoB_TEST(-1.2E+99,generalLimit,8,15,'.','0',0,_S("-1.2E+99")),
    RtoB_TEST(-1.2E-99,generalLimit,8,15,'.','0',0,_S("-1.2E-99")),
	//
    RtoB_TEST(1.2E+99,generalLimit,6,15,'.','0',0,_S("1E+99")),
    RtoB_TEST(1.2E-99,generalLimit,6,15,'.','0',0,_S("1E-99")),
    RtoB_TEST(-1.2E+99,generalLimit,7,15,'.','0',0,_S("-1E+99")),
    RtoB_TEST(-1.2E-99,generalLimit,7,15,'.','0',0,_S("-1E-99")),
	//
    RtoB_TEST(1.2E+99,generalLimit,5,15,'.','0',0,_S("1E+99")),
    RtoB_TEST(1.2E-99,generalLimit,5,15,'.','0',0,_S("1E-99")),
    RtoB_TEST(-1.2E+99,generalLimit,6,15,'.','0',0,_S("-1E+99")),
    RtoB_TEST(-1.2E-99,generalLimit,6,15,'.','0',0,_S("-1E-99")),
	//
    RtoB_TEST(1E+99,generalLimit,8,15,'.','0',0,_S("1E+99")),
    RtoB_TEST(1E-99,generalLimit,8,15,'.','0',0,_S("1E-99")),
    RtoB_TEST(-1E+99,generalLimit,9,15,'.','0',0,_S("-1E+99")),
    RtoB_TEST(-1E-99,generalLimit,9,15,'.','0',0,_S("-1E-99")),
	//
    RtoB_TEST(1E+99,generalLimit,7,15,'.','0',0,_S("1E+99")),
    RtoB_TEST(1E-99,generalLimit,7,15,'.','0',0,_S("1E-99")),
    RtoB_TEST(-1E+99,generalLimit,8,15,'.','0',0,_S("-1E+99")),
    RtoB_TEST(-1E-99,generalLimit,8,15,'.','0',0,_S("-1E-99")),
	//
    RtoB_TEST(1E+99,generalLimit,6,15,'.','0',0,_S("1E+99")),
    RtoB_TEST(1E-99,generalLimit,6,15,'.','0',0,_S("1E-99")),
    RtoB_TEST(-1E+99,generalLimit,7,15,'.','0',0,_S("-1E+99")),
    RtoB_TEST(-1E-99,generalLimit,7,15,'.','0',0,_S("-1E-99")),
	//
    RtoB_TEST(1E+99,generalLimit,5,15,'.','0',0,_S("1E+99")),
    RtoB_TEST(1E-99,generalLimit,5,15,'.','0',0,_S("1E-99")),
    RtoB_TEST(-1E+99,generalLimit,6,15,'.','0',0,_S("-1E+99")),
    RtoB_TEST(-1E-99,generalLimit,6,15,'.','0',0,_S("-1E-99")),
	//
    RtoB_TEST(0,generalLimit,2,14,'.','0',0,_S("0")),
    RtoB_TEST(1,generalLimit,2,14,'.','0',0,_S("1")),
    RtoB_TEST(370,generalLimit,20,14,'.','0',0,_S("370")),
    RtoB_TEST(-9E98,fixedLimitAndTriads,150,15,'.',',',3,_S("-900,000,000,000,000,000,000,\
000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,\
000,000,000,000,000,000,000.000000000000000")),
    RtoB_TEST(9E98,fixedLimitAndTriads,150,15,'.',',',3,_S("900,000,000,000,000,000,000,\
000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,\
000,000,000,000,000,000,000.000000000000000")),
    RtoB_TEST(90000000.0,generalLimit,20,3,'.','0',0,_S("90000000")),
    RtoB_TEST(90000000.0,generalLimit,9,3,'.','0',0,_S("90000000")),
    RtoB_TEST(90000000.0,generalLimit,7,3,'.','0',0,_S("9E+07")),
    RtoB_TEST(90000000.0,generalLimit,6,3,'.','0',0,_S("9E+07")),
    RtoB_TEST(-900,generalLimit,20,3,'.','0',0,_S("-900")),
    RtoB_TEST(-90000000.0,generalLimit,20,3,'.','0',0,_S("-90000000")),
    RtoB_TEST(-90000000.0,generalLimit,9,3,'.','0',0,_S("-90000000")),
    RtoB_TEST(-90000000.0,generalLimit,8,3,'.','0',0,_S("-9E+07")),
    RtoB_TEST(-90000000.0,generalLimit,6,3,'.','0',0,_S("-9E+07")),
    RtoB_TEST(900,generalLimit,20,3,'.','0',0,_S("900")),
    RtoB_TEST(-900,generalLimit,20,3,'.','0',0,_S("-900")),
    RtoB_TEST(999,generalLimit,3,3,'.','0',0,_S("999")),
    RtoB_TEST(999.1,generalLimit,3,3,'.','0',0,_S("999")),
    RtoB_TEST(999.1,generalLimit,4,3,'.','0',0,_S("999")),
    RtoB_TEST(-999.1,generalLimit,4,3,'.','0',0,_S("-999")),
    RtoB_TEST(-300,generalLimit,10,3,'.','0',0,_S("-300")),
    RtoB_TEST(-355555555.0,generalLimit,6,3,'.','0',0,_S("-4E+08")),
    RtoB_TEST(355555555.0,generalLimit,7,3,'.','0',0,_S("3.6E+08")),
    RtoB_TEST(355555555.0,generalLimit,6,3,'.','0',0,_S("4E+08")),
    RtoB_TEST(123456.0,generalLimit,6,4,'.','0',0,_S("123456")),
    RtoB_TEST(999999.0,generalLimit,6,4,'.','0',0,_S("999999")),
    RtoB_TEST(12346.0,generalLimit,5,4,'.','0',0,_S("12346")),
    RtoB_TEST(9999999.0,generalLimit,5,4,'.','0',0,_S("1E+07")),
	//
    RtoB_TEST(0.02,generalLimit,6,4,'.','0',0,_S("0.02")),
    RtoB_TEST(0.04,generalLimit,9,0,'.','0',0,_S("0.04")),
    RtoB_TEST(0.004,generalLimit,9,0,'.','0',0,_S("0.004")),
    RtoB_TEST(0.0004,generalLimit,9,0,'.','0',0, _S("4E-04")),
    RtoB_TEST(0.05,generalLimit,9,0,'.','0',0,_S("0.05")),
    RtoB_TEST(9.999999999964E-2,generalLimit,9,0,'.','0',0,_S("0.1")),
    RtoB_TEST(0.0000999,generalLimit,7,4,'.','0',0,_S("1E-04")),

	// FIXED FORMAT 
	// test -ve number < 1 with 0 dp
	RtoB_TEST(-0.01,KRealFormatFixed,7,0,'.','0',0,_S("0")),
	RtoB_TEST(-0.4999999999,KRealFormatFixed,7,0,'.','0',0,_S("0")),
	RtoB_TEST(-0.9,KRealFormatFixed,7,0,'.','0',0,_S("-1")),
	RtoB_TEST(-0.51,KRealFormatFixed,7,0,'.','0',0,_S("-1")),
	// No Triad separators (because length zero), no space for sign 
    RtoB_TEST(0.0,KRealFormatFixed,7,0,'.','0',0,_S("0")),
	RtoB_TEST(KNegZeroTReal64,KRealFormatFixed,7,0,'.','0',0,_S("0")),
	RtoB_TEST(0.0,KRealFormatFixed,7,0,'.','0',0,_S("0")),
    RtoB_TEST(0.0,KRealFormatFixed,7,2,'.','0',0,_S("0.00")),			
    RtoB_TEST(0.0,KRealFormatFixed,7,3,'.','0',0,_S("0.000")),		
    RtoB_TEST(0.0,KRealFormatFixed,7,4,'.','0',0,_S("0.0000")),		
    RtoB_TEST(3.0,KRealFormatFixed,7,3,'.','0',0,_S("3.000")),
    RtoB_TEST(12.9999,KRealFormatFixed,6,3,'.','0',0,_S("13.000")),
    RtoB_TEST(123456.789,KRealFormatFixed,9,2,'.','0',0,_S("123456.79")),
    RtoB_TEST(123456.0,KRealFormatFixed,9,2,'.','0',0,_S("123456.00")),
    RtoB_TEST(1234567890123.,KRealFormatFixed,18,1,'.',',',0,_S("1234567890123.0")),
    RtoB_TEST(123456.789,KRealFormatFixed,9,2,'.',',',0,_S("123456.79")),
    RtoB_TEST(123456.0,KRealFormatFixed,9,2,'.',',',0,_S("123456.00")),
    RtoB_TEST(1234567890123.,KRealFormatFixed,18,1,'.','0',0,_S("1234567890123.0")),
	RtoB_TEST(.0453,KRealFormatFixed,12,4,'.','0',0,_S("0.0453")),
    RtoB_TEST(.0453,KRealFormatFixed,12,2,'.','0',0,_S("0.05")),
    RtoB_TEST(.0453,KRealFormatFixed,12,5,'.','0',0,_S("0.04530")),
    RtoB_TEST(.00000876,KRealFormatFixed,11,9,'.','0',0,_S("0.000008760")),
    RtoB_TEST(.00000876,KRealFormatFixed,11,8,'.','0',0,_S("0.00000876")),
    RtoB_TEST(.00000876,KRealFormatFixed,11,7,'.','0',0,_S("0.0000088")),
    RtoB_TEST(.00000876,KRealFormatFixed,11,6,'.','0',0,_S("0.000009")),
    RtoB_TEST(.00000876,KRealFormatFixed,11,5,'.','0',0,_S("0.00001")),
    RtoB_TEST(.123,KRealFormatFixed,5,3,'.','0',0,_S("0.123")),
    RtoB_TEST(.1235,KRealFormatFixed,5,3,'.','0',0,_S("0.124")),
    RtoB_TEST(1.0E4,KRealFormatFixed,10,2,'.',',',0,_S("10000.00")),
	RtoB_TEST(1.0E-4,KRealFormatFixed,10,2,'.',',',0,_S("0.00")),	
	// No triad separators (because flag not set), no space for sign
	RtoB_TEST(123456.789,fixedNoTriads,9,2,'.','0',3,_S("123456.79")),
    RtoB_TEST(123456.0,fixedNoTriads,9,2,'.','0',3,_S("123456.00")),
    RtoB_TEST(1234567890123.,fixedNoTriads,18,1,'.',',',3,_S("1234567890123.0")),
    RtoB_TEST(123456.789,fixedNoTriads,9,2,'.',',',3,_S("123456.79")),
    RtoB_TEST(123456.0,fixedNoTriads,9,2,'.',',',3,_S("123456.00")),
    RtoB_TEST(1234567890123.,fixedNoTriads,18,1,'.','0',3,_S("1234567890123.0")),
	RtoB_TEST(.00000876,fixedNoTriads,11,9,'.','0',3,_S("0.000008760")),
    RtoB_TEST(.00000876,fixedNoTriads,11,8,'.','0',3,_S("0.00000876")),
    RtoB_TEST(.00000876,fixedNoTriads,11,7,'.','0',3,_S("0.0000088")),
    RtoB_TEST(.00000876,fixedNoTriads,11,6,'.','0',3,_S("0.000009")),
    RtoB_TEST(.00000876,fixedNoTriads,11,5,'.','0',3,_S("0.00001")),
    // UK Triad separators, no space for sign 
    RtoB_TEST(0.0,KRealFormatFixed,9,2,'.',',',3,_S("0.00")),
    RtoB_TEST(.00568,KRealFormatFixed,9,2,'.',',',3,_S("0.01")),
    RtoB_TEST(12345.0,KRealFormatFixed,9,2,'.',',',3,_S("12,345.00")),
    RtoB_TEST(12345.669,KRealFormatFixed,9,2,'.',',',3,_S("12,345.67")),
    RtoB_TEST(100000.0,KRealFormatFixed,10,2,'.',',',3,_S("100,000.00")),
    RtoB_TEST(99999.999,KRealFormatFixed,10,2,'.',',',3,_S("100,000.00")),
    RtoB_TEST(1234567890.675,KRealFormatFixed,16,2,'.',',',3,_S("1,234,567,890.68")),
    RtoB_TEST(1.0E3,KRealFormatFixed,10,2,'.',',',3,_S("1,000.00")),
    // French Triad separators, no space for sign 
    RtoB_TEST(0.0,KRealFormatFixed,10,2,',',' ',4,_S("0,00")),
    RtoB_TEST(.00568,KRealFormatFixed,10,2,',',' ',4,_S("0,01")),
    RtoB_TEST(1.0E3,KRealFormatFixed,10,2,',',' ',4,_S("1000,00")),
    RtoB_TEST(1234.0,KRealFormatFixed,10,2,',',' ',4,_S("1234,00")),
    RtoB_TEST(12345.0,KRealFormatFixed,9,2,',',' ',4,_S("12 345,00")),
    RtoB_TEST(12345.669,KRealFormatFixed,9,2,',',' ',4,_S("12 345,67")),
    RtoB_TEST(100000.0,KRealFormatFixed,10,2,',',' ',4,_S("100 000,00")),
    RtoB_TEST(99999.999,KRealFormatFixed,10,2,',',' ',4,_S("100 000,00")),
    RtoB_TEST(1234567890.675,KRealFormatFixed,16,2,',',' ',4,_S("1 234 567 890,68")),
    // '.' as triad separator, and ',' as decimal point, no space for sign 
    RtoB_TEST(1234.0,KRealFormatFixed,10,2,',','.',3,_S("1.234,00")),
	RtoB_TEST(0.0,KRealFormatFixed,10,2,',','.',3,_S("0,00")),
    RtoB_TEST(.00568,KRealFormatFixed,10,2,',','.',3,_S("0,01")),
    RtoB_TEST(1.0E3,KRealFormatFixed,10,2,',','.',3,_S("1.000,00")),
    RtoB_TEST(12345.669,KRealFormatFixed,9,2,',','.',3,_S("12.345,67")),
    RtoB_TEST(12345.0,KRealFormatFixed,9,2,',','.',4,_S("12.345,00")),
    RtoB_TEST(100000.0,KRealFormatFixed,10,2,',','.',3,_S("100.000,00")),
    RtoB_TEST(99999.999,KRealFormatFixed,10,2,',','.',3,_S("100.000,00")),
    RtoB_TEST(1234567890.675,KRealFormatFixed,16,2,',','.',3,_S("1.234.567.890,68")),
	// Added by AnnW
	// no triads, space for sign
	RtoB_TEST(0.0,fixedSpaceForSign,2,0,'.','0',0,_S("0")),					
    RtoB_TEST(3.0,fixedSpaceForSign,6,3,'.','0',0,_S("3.000")),
	RtoB_TEST(-3.0,fixedSpaceForSign,6,3,'.','0',0,_S("-3.000")),			
    RtoB_TEST(12.9999,fixedSpaceForSign,7,3,'.','0',0,_S("13.000")),
	RtoB_TEST(-12.9999,fixedSpaceForSign,7,3,'.','0',0,_S("-13.000")),		
    RtoB_TEST(123456.789,fixedSpaceForSign,10,2,'.','0',0,_S("123456.79")),
	RtoB_TEST(-123456.789,fixedSpaceForSign,10,2,'.','0',0,_S("-123456.79")),
    RtoB_TEST(1234567890123.,fixedSpaceForSign,16,1,'.','0',0,_S("1234567890123.0")),
    RtoB_TEST(-1234567890123.,fixedSpaceForSign,16,1,'.','0',0,_S("-1234567890123.0")),
	RtoB_TEST(.0453,fixedSpaceForSign,12,4,'.','0',0,_S("0.0453")),
    RtoB_TEST(.0453,fixedSpaceForSign,12,2,'.','0',0,_S("0.05")),
    RtoB_TEST(.0453,fixedSpaceForSign,12,5,'.','0',0,_S("0.04530")),
    RtoB_TEST(.00000876,fixedSpaceForSign,11,8,'.','0',0,_S("0.00000876")),
    RtoB_TEST(-.00000876,fixedSpaceForSign,11,8,'.','0',0,_S("-0.00000876")),
    RtoB_TEST(.00000876,fixedSpaceForSign,9,6,'.','0',0,_S("0.000009")),
	RtoB_TEST(-.00000876,fixedSpaceForSign,9,6,'.','0',0,_S("-0.000009")),
    RtoB_TEST(.1235,fixedSpaceForSign,6,3,'.','0',0,_S("0.124")),
	RtoB_TEST(-.1235,fixedSpaceForSign,6,3,'.','0',0,_S("-0.124")),
	// UK triads and space for sign
	RtoB_TEST(0.0,fixedTriadsAndSign,10,2,'.',',',3,_S("0.00")),
    RtoB_TEST(.00568,fixedTriadsAndSign,10,2,'.',',',3,_S("0.01")),
	RtoB_TEST(-.00568,fixedTriadsAndSign,10,2,'.',',',3,_S("-0.01")),
    RtoB_TEST(12345.0,fixedTriadsAndSign,10,2,'.',',',3,_S("12,345.00")),
    RtoB_TEST(-12345.0,fixedTriadsAndSign,10,2,'.',',',3,_S("-12,345.00")),
    RtoB_TEST(100000.0,fixedTriadsAndSign,11,2,'.',',',3,_S("100,000.00")),
    RtoB_TEST(99999.999,fixedTriadsAndSign,11,2,'.',',',3,_S("100,000.00")),
	RtoB_TEST(-99999.999,fixedTriadsAndSign,11,2,'.',',',3,_S("-100,000.00")),
    RtoB_TEST(1234567890.675,fixedTriadsAndSign,17,2,'.',',',3,_S("1,234,567,890.68")),
    RtoB_TEST(-1234567890.675,fixedTriadsAndSign,17,2,'.',',',3,_S("-1,234,567,890.68")),
	RtoB_TEST(1.0E3,fixedTriadsAndSign,9,2,'.',',',3,_S("1,000.00")),
    RtoB_TEST(-1.0E3,fixedTriadsAndSign,9,2,'.',',',3,_S("-1,000.00")),
	//
	RtoB_TEST(1234.9876E-107,KRealFormatFixed,12,6,'.','0',0,_S("0.000000")),
    RtoB_TEST(1234.9876E-109,KRealFormatFixed,12,6,'.','0',0,_S("0.000000")),
    RtoB_TEST(1234.9876E-110,KRealFormatFixed,12,6,'.','0',0,_S("0.000000")),
    RtoB_TEST(1234.9876E-200,KRealFormatFixed,12,6,'.','0',0,_S("0.000000")),
    RtoB_TEST(1234.9876E-300,KRealFormatFixed,12,6,'.','0',0,_S("0.000000")),

	// FIXED FORMAT
	// Limited
	RtoB_TEST(1.23456789012501,fixedLimit,32,15,'.',',',0,_S("1.234567890130000")),
    RtoB_TEST(1.2345678901249,fixedLimit,32,15,'.',',',3,_S("1.234567890120000")),
    RtoB_TEST(1.99999999996,fixedLimit,32,15,'.',',',0,_S("1.999999999960000")),
    RtoB_TEST(1.999999999996,fixedLimit,32,15,'.',',',0,_S("2.000000000000000")),
    RtoB_TEST(1.9999999999996,fixedLimit,32,15,'.',',',3,_S("2.000000000000000")),
    RtoB_TEST(1.99999999999996,fixedLimit,32,15,'.',',',3,_S("2.000000000000000")),
	//
	RtoB_TEST(1.23456789012501E+6,fixedLimitAndTriads,32,9,'.',',',3,_S("1,234,567.890130000")),
    RtoB_TEST(1.2345678901249E+8,fixedLimitAndTriads,32,7,'.',',',3,_S("123,456,789.0120000")),
    RtoB_TEST(1.99999999996E+3,fixedLimitAndTriads,32,12,'.',',',3,_S("1,999.999999960000")),
    RtoB_TEST(1.999999999996E+12,fixedLimitAndTriads,32,3,'.',',',3,_S("2,000,000,000,000.000")),
    RtoB_TEST(1.9999999999996E+4,fixedLimitAndTriads,32,11,'.',',',3,_S("20,000.00000000000")),
    RtoB_TEST(1.99999999999996E+13,fixedLimitAndTriads,32,2,'.',',',3,_S("20,000,000,000,000.00")),
	//
	RtoB_TEST(1.23456789012501,fixedLimitAndSpaceForSign,32,15,'.',',',0,_S("1.234567890130000")),
    RtoB_TEST(1.2345678901249,fixedLimitAndSpaceForSign,32,15,'.',',',3,_S("1.234567890120000")),
    RtoB_TEST(1.99999999996,fixedLimitAndSpaceForSign,32,15,'.',',',0,_S("1.999999999960000")),
    RtoB_TEST(1.999999999996,fixedLimitAndSpaceForSign,32,15,'.',',',0,_S("2.000000000000000")),
    RtoB_TEST(1.9999999999996,fixedLimitAndSpaceForSign,32,15,'.',',',3,_S("2.000000000000000")),
    RtoB_TEST(1.99999999999996,fixedLimitAndSpaceForSign,32,15,'.',',',3,_S("2.000000000000000")),
	// end of added

	// EXPONENT FORMAT 
    // Zero Exponents 
    RtoB_TEST(0.0,KRealFormatExponent,8,0,'.','0',0,_S("0E+00")),
    RtoB_TEST(0.0,KRealFormatExponent,8,2,'.','0',0,_S("0.00E+00")),
    RtoB_TEST(9.0,KRealFormatExponent,8,2,'.','0',0,_S("9.00E+00")),
    RtoB_TEST(9.9,KRealFormatExponent,8,2,'.','0',0,_S("9.90E+00")),
    RtoB_TEST(1234.9876E-3,KRealFormatExponent,12,6,'.','0',0,_S("1.234988E+00")),
    // Positive Exponents, not allowing three-digit exponents 
    RtoB_TEST(123.098785,KRealFormatExponent,8,2,'.','0',0,_S("1.23E+02")),
    RtoB_TEST(123.098785,KRealFormatExponent,12,3,'.','0',0,_S("1.231E+02")),
    RtoB_TEST(123.098785,KRealFormatExponent,12,4,'.','0',0,_S("1.2310E+02")),
    RtoB_TEST(123.098785,KRealFormatExponent,12,5,'.','0',0,_S("1.23099E+02")),
    RtoB_TEST(123.098785,KRealFormatExponent,12,6,'.','0',0,_S("1.230988E+02")),
    RtoB_TEST(98765.0,KRealFormatExponent,12,5,'.','0',0,_S("9.87650E+04")),
    RtoB_TEST(10000000.0,KRealFormatExponent,8,2,'.','0',0,_S("1.00E+07")),
    RtoB_TEST(100000000.0,KRealFormatExponent,12,6,'.','0',0,_S("1.000000E+08")),
    RtoB_TEST(100000000.000087643,KRealFormatExponent,12,6,'.','0',0,_S("1.000000E+08")),
    RtoB_TEST(999999999.999,KRealFormatExponent,8,2,'.','0',0,_S("1.00E+09")),
    RtoB_TEST(1234567.8765E12,KRealFormatExponent,8,2,'.','0',0,_S("1.23E+18")),
    RtoB_TEST(1234567.8765E12,KRealFormatExponent,12,6,'.','0',0,_S("1.234568E+18")),
    RtoB_TEST(34574567645555555.0E35,KRealFormatExponent,12,6,'.','0',0,_S("3.457457E+51")),
    RtoB_TEST(123.098785E56,KRealFormatExponent,12,6,'.','0',0,_S("1.230988E+58")),
    RtoB_TEST(.99999999E99,KRealFormatExponent,12,6,'.','0',0,_S("1.000000E+99")),
    RtoB_TEST(1.0E99,KRealFormatExponent,12,6,'.','0',0,_S("1.000000E+99")),
    // Negative Exponents, not allowing three-digit exponents 
    RtoB_TEST(1234.9876E-4,KRealFormatExponent,12,6,'.','0',0,_S("1.234988E-01")),
    RtoB_TEST(.0000000001235,KRealFormatExponent,8,2,'.','0',0,_S("1.24E-10")),
    RtoB_TEST(.0000000001235,KRealFormatExponent,8,1,'.','0',0,_S("1.2E-10")),
    RtoB_TEST(.0000000001235,KRealFormatExponent,9,3,'.','0',0,_S("1.235E-10")),
    RtoB_TEST(.00000000999,KRealFormatExponent,8,2,'.','0',0,_S("9.99E-09")),
    RtoB_TEST(.0000000001,KRealFormatExponent,12,6,'.','0',0,_S("1.000000E-10")),
    RtoB_TEST(.00000000010001,KRealFormatExponent,12,6,'.','0',0,_S("1.000100E-10")),
    RtoB_TEST(123.098785E-32,KRealFormatExponent,12,6,'.','0',0,_S("1.230988E-30")),
    RtoB_TEST(123.098785E-87,KRealFormatExponent,12,6,'.','0',0,_S("1.230988E-85")),
    RtoB_TEST(1.0E-99,KRealFormatExponent,12,6,'.','0',0,_S("1.000000E-99")),
	// Added by AnnW
	// Positive Exponents, allowing three-digit exponents 
    RtoB_TEST(123.098785,exponentThreeDigitExp,12,6,'.','0',0,_S("1.230988E+02")),
    RtoB_TEST(999999999.999,exponentThreeDigitExp,8,2,'.','0',0,_S("1.00E+09")),
    RtoB_TEST(34574567645555555.0E35,exponentThreeDigitExp,12,6,'.','0',0,_S("3.457457E+51")),
    RtoB_TEST(.99999999E99,exponentThreeDigitExp,12,6,'.','0',0,_S("1.000000E+99")),
    RtoB_TEST(1.0E99,exponentThreeDigitExp,12,6,'.','0',0,_S("1.000000E+99")),
	RtoB_TEST(1234.9876E-103,exponentThreeDigitExp,14,7,'.','0',0,_S("1.2349876E-100")),
    RtoB_TEST(1234.9876E-107,exponentThreeDigitExp,14,6,'.','0',0,_S("1.234988E-104")),
    RtoB_TEST(1234.9876E-109,exponentThreeDigitExp,14,7,'.','0',0,_S("1.2349876E-106")),
    RtoB_TEST(1234.9876E-110,exponentThreeDigitExp,14,7,'.','0',0,_S("1.2349876E-107")),
    RtoB_TEST(1234.9876E-200,exponentThreeDigitExp,14,7,'.','0',0,_S("1.2349876E-197")),
    RtoB_TEST(1234.9876E-300,exponentThreeDigitExp,14,7,'.','0',0,_S("1.2349876E-297")),
    RtoB_TEST(1234.9876E97,exponentThreeDigitExp,14,7,'.','0',0,_S("1.2349876E+100")),
    RtoB_TEST(1234.9876E100,exponentThreeDigitExp,14,7,'.','0',0,_S("1.2349876E+103")),
    RtoB_TEST(1234.9876E103,exponentThreeDigitExp,14,5,'.','0',0,_S("1.23499E+106")),
    RtoB_TEST(1234.9876E200,exponentThreeDigitExp,14,7,'.','0',0,_S("1.2349876E+203")),
    RtoB_TEST(1234.9876E300,exponentThreeDigitExp,14,7,'.','0',0,_S("1.2349876E+303")),
    // Negative Exponents, allowing three-digit exponents 
    RtoB_TEST(1234.9876E-4,exponentThreeDigitExp,12,6,'.','0',0,_S("1.234988E-01")),
    RtoB_TEST(.00000000999,exponentThreeDigitExp,8,2,'.','0',0,_S("9.99E-09")),
    RtoB_TEST(123.098785E-32,exponentThreeDigitExp,12,6,'.','0',0,_S("1.230988E-30")),
    RtoB_TEST(123.098785E-87,exponentThreeDigitExp,12,6,'.','0',0,_S("1.230988E-85")),
    RtoB_TEST(1.0E-99,exponentThreeDigitExp,12,6,'.','0',0,_S("1.000000E-99")),
	// Limited
	RtoB_TEST(1.23456789012501E24,exponentLimit,32,15,'.',',',3,_S("1.234567890130000E+24")),
    RtoB_TEST(1.2345678901249E+97,exponentLimit,32,15,'.',',',3,_S("1.234567890120000E+97")),
    RtoB_TEST(1.99999999996E-19,exponentLimit,32,15,'.',',',3,_S("1.999999999960000E-19")),
    RtoB_TEST(1.999999999996E-53,exponentLimit,32,15,'.',',',3,_S("2.000000000000000E-53")),
    RtoB_TEST(1.9999999999996E+46,exponentLimit,32,15,'.',',',3,_S("2.000000000000000E+46")),
    RtoB_TEST(1.99999999999996,exponentLimit,32,15,'.',',',3,_S("2.000000000000000E+00")),
	//
	RtoB_TEST(1.23456789012501E24,exponentLimitAndThreeDigExp,32,15,'.',',',3,_S("1.234567890130000E+24")),
    RtoB_TEST(1.2345678901249E+169,exponentLimitAndThreeDigExp,32,15,'.',',',3,_S("1.234567890120000E+169")),
    RtoB_TEST(1.99999999996E-19,exponentLimitAndThreeDigExp,32,15,'.',',',3,_S("1.999999999960000E-19")),
    RtoB_TEST(1.999999999996E-253,exponentLimitAndThreeDigExp,32,15,'.',',',3,_S("2.000000000000000E-253")),
    RtoB_TEST(1.9999999999996E+246,exponentLimitAndThreeDigExp,32,15,'.',',',3,_S("2.000000000000000E+246")),
    RtoB_TEST(1.99999999999996E-302,exponentLimitAndThreeDigExp,32,15,'.',',',3,_S("2.000000000000000E-302")),
	// end of added
	
	// GENERAL FORMAT 
    // Fixed format, no space for sign 
    RtoB_TEST(0.000,KRealFormatGeneral,7,4,'.','0',0,_S("0")),
    RtoB_TEST(98.000,KRealFormatGeneral,7,4,'.','0',0,_S("98")),
    RtoB_TEST(12345.6700009,KRealFormatGeneral,12,4,'.','0',3,_S("12345.670001")),
    RtoB_TEST(1.E2,KRealFormatGeneral,3,4,'.','0',0,_S("100")),
    RtoB_TEST(1234.0,KRealFormatGeneral,4,4,'.','0',3,_S("1234")),
    RtoB_TEST(1.2345,KRealFormatGeneral,4,4,'.','0',0,_S("1.23")),
    RtoB_TEST(1.235,KRealFormatGeneral,4,4,'.','0',0,_S("1.24")),
    RtoB_TEST(98765.0,KRealFormatGeneral,13,6,'.','0',0,_S("98765")),
    RtoB_TEST(100000000.0,KRealFormatGeneral,13,6,'.','0',0,_S("100000000")),
    RtoB_TEST(123.098785E00,KRealFormatGeneral,10,6,'.','0',0,_S("123.098785")),
	RtoB_TEST(-123.098785E00,KRealFormatGeneral,10,6,'.','0',0,_S("-123.09879")),
    RtoB_TEST(0.001209,KRealFormatGeneral,6,4,'.','0',0,_S("0.0012")),
    RtoB_TEST(0.00100987,KRealFormatGeneral,7,4,'.','0',0,_S("0.00101")),
    RtoB_TEST(1234.9876E-4,KRealFormatGeneral,13,6,'.','0',0,_S("0.12349876")),
    RtoB_TEST(1234.9876E-5,KRealFormatGeneral,13,6,'.','0',0,_S("0.012349876")),
    // Fixed format, space for sign 
    RtoB_TEST(0.000,generalSpaceForSign,7,4,'.','0',0,_S("0")),
    RtoB_TEST(98.000,generalSpaceForSign,7,4,'.','0',0,_S("98")),
    RtoB_TEST(12345.6700009,generalSpaceForSign,13,4,'.','0',3,_S("12345.670001")),
	RtoB_TEST(-12345.6700009,generalSpaceForSign,13,4,'.','0',3,_S("-12345.670001")),
    RtoB_TEST(1.E2,generalSpaceForSign,4,4,'.','0',0,_S("100")),
    RtoB_TEST(1234.0,generalSpaceForSign,5,4,'.','0',3,_S("1234")),
    RtoB_TEST(1.2345,generalSpaceForSign,5,4,'.','0',0,_S("1.23")),
    RtoB_TEST(1.235,generalSpaceForSign,5,4,'.','0',0,_S("1.24")),
    RtoB_TEST(-1.235,generalSpaceForSign,5,4,'.','0',0,_S("-1.24")),
	RtoB_TEST(98765.0,generalSpaceForSign,13,6,'.','0',0,_S("98765")),
    RtoB_TEST(100000000.0,generalSpaceForSign,13,6,'.','0',0,_S("100000000")),
    RtoB_TEST(123.098785E00,generalSpaceForSign,11,6,'.','0',0,_S("123.098785")),
	RtoB_TEST(-123.098785E00,generalSpaceForSign,11,6,'.','0',0,_S("-123.098785")),
    RtoB_TEST(0.001209,generalSpaceForSign,7,4,'.','0',0,_S("0.0012")),
    RtoB_TEST(0.00100987,generalSpaceForSign,8,4,'.','0',0,_S("0.00101")),
    RtoB_TEST(1234.9876E-4,generalSpaceForSign,11,6,'.','0',0,_S("0.12349876")),
	RtoB_TEST(-1234.9876E-4,generalSpaceForSign,11,6,'.','0',0,_S("-0.12349876")),
    RtoB_TEST(1234.9876E-5,generalSpaceForSign,12,6,'.','0',0,_S("0.012349876")),
	RtoB_TEST(-1234.9876E-5,generalSpaceForSign,12,6,'.','0',0,_S("-0.012349876")),
	// Initially the format type is exponent, but after rounding
    // it is changed to fixed
	// no space for sign 
    RtoB_TEST(0.00099,KRealFormatGeneral,5,5,'.','0',0,_S("0.001")),
    RtoB_TEST(0.00099999109,KRealFormatGeneral,6,5,'.','0',0,_S("0.001")),
    // space allowed for sign
	RtoB_TEST(0.00099,generalSpaceForSign,6,5,'.','0',0,_S("0.001")),
    RtoB_TEST(0.00099999109,generalSpaceForSign,7,5,'.','0',0,_S("0.001")),
    // Exponent format, two digit exponent only 
    RtoB_TEST(10000000.0,KRealFormatGeneral,7,4,'.','0',0,_S("1E+07")),
    RtoB_TEST(9999999.0,KRealFormatGeneral,6,4,'.','0',0,_S("1E+07")),
    RtoB_TEST(1234567890123.0,KRealFormatGeneral,12,4,'.','0',0,_S("1.234568E+12")),
    RtoB_TEST(1234567.8765E12,KRealFormatGeneral,10,6,'.','0',0,_S("1.2346E+18")),
    RtoB_TEST(123.098785E56,KRealFormatGeneral,12,6,'.','0',0,_S("1.230988E+58")),
    RtoB_TEST(0.0000678,KRealFormatGeneral,12,4,'.','0',0,_S("6.78E-05")),
    RtoB_TEST(0.0000001234,KRealFormatGeneral,12,4,'.','0',0,_S("1.234E-07")),
    RtoB_TEST(.99999999E99,KRealFormatGeneral,12,6,'.','0',0,_S("1E+99")),
    RtoB_TEST(1.0E99,KRealFormatGeneral,12,6,'.','0',0,_S("1E+99")),
    RtoB_TEST(.0000000001,KRealFormatGeneral,12,6,'.','0',0,_S("1E-10")),
    RtoB_TEST(5384795.26E-52,KRealFormatGeneral,12,6,'.','0',0,_S("5.384795E-46")),
    RtoB_TEST(123.098785E-87,KRealFormatGeneral,12,6,'.','0',0,_S("1.230988E-85")),
    RtoB_TEST(.99999999E-99,KRealFormatGeneral,12,6,'.','0',0,_S("1E-99")),
    RtoB_TEST(1.0E-99,KRealFormatGeneral,12,6,'.','0',0,_S("1E-99")),
	// Exponent format, three-digit exponents allowed
    RtoB_TEST(9999999.0,generalThreeDigitExp,6,4,'.','0',0,_S("1E+07")),
    RtoB_TEST(1234567890123.0,generalThreeDigitExp,13,4,'.','0',0,_S("1234567890123")),	// Leave room for three-digit exponent, so can have fixed numbers one digit longer 
    RtoB_TEST(1234567.8765E12,generalThreeDigitExp,11,6,'.','0',0,_S("1.23457E+18")),
    RtoB_TEST(123.098785E56,generalThreeDigitExp,12,6,'.','0',0,_S("1.230988E+58")),
    RtoB_TEST(.99999999E99,generalThreeDigitExp,12,6,'.','0',0,_S("1E+99")),
    RtoB_TEST(1.0E99,generalThreeDigitExp,12,6,'.','0',0,_S("1E+99")),
    RtoB_TEST(.0000000001,generalThreeDigitExp,12,6,'.','0',0,_S("1E-10")),
    RtoB_TEST(5384795.26E-52,generalThreeDigitExp,12,6,'.','0',0,_S("5.384795E-46")),
    RtoB_TEST(.99999999E-99,generalThreeDigitExp,12,6,'.','0',0,_S("1E-99")),
    RtoB_TEST(1.0E-99,generalThreeDigitExp,12,6,'.','0',0,_S("1E-99")),
	RtoB_TEST(1234.9876E-103,generalThreeDigitExp,12,15,'.','0',0,_S("1.23499E-100")),
    RtoB_TEST(1234.9876E-107,generalThreeDigitExp,22,7,'.','0',0,_S("1.2349876E-104")),
    RtoB_TEST(1234.9876E-109,generalThreeDigitExp,22,15,'.','0',0,_S("1.2349876E-106")),
    RtoB_TEST(1234.9876E-110,generalThreeDigitExp,22,15,'.','0',0,_S("1.2349876E-107")),
    RtoB_TEST(1234.9876E-200,generalThreeDigitExp,22,15,'.','0',0,_S("1.2349876E-197")),
    RtoB_TEST(1234.9876E-300,generalThreeDigitExp,22,15,'.','0',0,_S("1.2349876E-297")),
    RtoB_TEST(1234.9876E97,generalThreeDigitExp,12,15,'.','0',0,_S("1.23499E+100")),
    RtoB_TEST(1234.9876E100,generalThreeDigitExp,22,15,'.','0',0,_S("1.2349876E+103")),
    RtoB_TEST(1234.9876E103,generalThreeDigitExp,22,15,'.','0',0,_S("1.2349876E+106")),
    RtoB_TEST(1234.9876E200,generalThreeDigitExp,22,15,'.','0',0,_S("1.2349876E+203")),
    RtoB_TEST(1234.9876E300,generalThreeDigitExp,22,15,'.','0',0,_S("1.2349876E+303")),
	//
	RtoB_TEST(1.2E+100,generalThreeDigitExp,6,15,'.','0',0,_S("1E+100")),
    RtoB_TEST(1.2E-100,generalThreeDigitExp,6,15,'.','0',0,_S("1E-100")),
    RtoB_TEST(-1.2E+100,generalThreeDigitExp,7,15,'.','0',0,_S("-1E+100")),
    RtoB_TEST(-1.2E-100,generalThreeDigitExp,7,15,'.','0',0,_S("-1E-100")),
    RtoB_TEST(1.2E+100,generalThreeDigitExp,8,15,'.','0',0,_S("1.2E+100")),
    RtoB_TEST(1.2E-100,generalThreeDigitExp,8,15,'.','0',0,_S("1.2E-100")),
    RtoB_TEST(-1.2E+100,generalThreeDigitExp,9,15,'.','0',0,_S("-1.2E+100")),
    RtoB_TEST(-1.2E-100,generalThreeDigitExp,9,15,'.','0',0,_S("-1.2E-100")),
    RtoB_TEST(1E+100,generalThreeDigitExp,6,15,'.','0',0,_S("1E+100")),
    RtoB_TEST(1E-100,generalThreeDigitExp,6,15,'.','0',0,_S("1E-100")),
    RtoB_TEST(-1E+100,generalThreeDigitExp,7,15,'.','0',0,_S("-1E+100")),
    RtoB_TEST(-1E-100,generalThreeDigitExp,7,15,'.','0',0,_S("-1E-100")),
    RtoB_TEST(1E+100,generalThreeDigitExp,7,15,'.','0',0,_S("1E+100")),
    RtoB_TEST(1E-100,generalThreeDigitExp,7,15,'.','0',0,_S("1E-100")),
    RtoB_TEST(-1E+100,generalThreeDigitExp,8,15,'.','0',0,_S("-1E+100")),
    RtoB_TEST(-1E-100,generalThreeDigitExp,8,15,'.','0',0,_S("-1E-100")),
	//
	RtoB_TEST(1.4E+308,generalThreeDigitExp,6,15,'.','0',0,_S("1E+308")),
    RtoB_TEST(2.3E-308,generalThreeDigitExp,6,15,'.','0',0,_S("2E-308")),
    RtoB_TEST(-1.4E+308,generalThreeDigitExp,7,15,'.','0',0,_S("-1E+308")),
    RtoB_TEST(-2.3E-308,generalThreeDigitExp,7,15,'.','0',0,_S("-2E-308")),
    RtoB_TEST(1.7E+308,generalThreeDigitExp,8,15,'.','0',0,_S("1.7E+308")),
    RtoB_TEST(2.3E-308,generalThreeDigitExp,8,15,'.','0',0,_S("2.3E-308")),
    RtoB_TEST(-1.7E+308,generalThreeDigitExp,9,15,'.','0',0,_S("-1.7E+308")),
    RtoB_TEST(-2.3E-308,generalThreeDigitExp,9,15,'.','0',0,_S("-2.3E-308")),
    RtoB_TEST(1.797693E+308,generalThreeDigitExp,15,15,'.','0',0,_S("1.797693E+308")),
    RtoB_TEST(2.225074E-308,generalThreeDigitExp,15,15,'.','0',0,_S("2.225074E-308")),
    RtoB_TEST(-1.797693E+308,generalThreeDigitExp,16,15,'.','0',0,_S("-1.797693E+308")),
    RtoB_TEST(-2.225074E-308,generalThreeDigitExp,16,15,'.','0',0,_S("-2.225074E-308"))
	};

GLDEF_D TUint size_testd=sizeof(testd);

 
