/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.sqlite.Codes;
import org.sqlite.Conn;
import org.sqlite.DB;
import org.sqlite.Unused;

abstract class RS
extends Unused
implements ResultSet,
ResultSetMetaData,
Codes {
    Conn conn;
    DB db;
    long pointer = 0L;
    boolean isAfterLast = false;
    boolean resultsWaiting = false;
    int maxRows;
    String[] cols = null;
    String[] colsMeta = null;
    boolean[][] meta = null;
    private int limitRows;
    private int row = 1;
    private int lastCol;

    RS(Conn conn) {
        this.conn = conn;
        this.db = conn.db();
    }

    protected final void checkOpen() throws SQLException {
        if (this.db == null) {
            throw new SQLException("statement is closed");
        }
    }

    protected final void checkExec() throws SQLException {
        if (this.pointer == 0L) {
            throw new SQLException("statement is not executing");
        }
    }

    protected final void checkRS() throws SQLException {
        if (this.db == null || !this.isRS()) {
            throw new SQLException("ResultSet closed");
        }
    }

    protected final boolean isRS() {
        return this.cols != null;
    }

    private int checkCol(int n) throws SQLException {
        this.checkOpen();
        if (this.colsMeta == null) {
            throw new IllegalStateException("SQLite JDBC: inconsistent internal state");
        }
        if (n < 1 || n > this.colsMeta.length) {
            throw new SQLException("column " + n + " out of bounds [1," + this.colsMeta.length + "]");
        }
        return --n;
    }

    private int markCol(int n) throws SQLException {
        this.checkRS();
        this.checkCol(n);
        this.lastCol = n--;
        return n;
    }

    private void checkMeta() throws SQLException {
        this.checkCol(1);
        if (this.meta == null) {
            this.meta = this.db.column_metadata(this.pointer, this.cols);
        }
    }

    public int findColumn(String string) throws SQLException {
        this.checkRS();
        for (int i = 0; i < this.cols.length; ++i) {
            if (!string.equalsIgnoreCase(this.cols[i])) continue;
            return i + 1;
        }
        throw new SQLException("no such column: '" + string + "'");
    }

    public boolean next() throws SQLException {
        if (this.isAfterLast) {
            return false;
        }
        this.lastCol = -1;
        if (this.row == 1) {
            ++this.row;
            return true;
        }
        if (this.maxRows != 0 && this.row > this.maxRows) {
            return false;
        }
        if (this.limitRows != 0 && this.row >= this.limitRows) {
            return false;
        }
        int n = this.db.step(this.pointer);
        if (n == 1) {
            this.db.reset(this.pointer);
        }
        switch (n) {
            case 5: {
                throw new SQLException("database locked");
            }
            case 101: {
                this.isAfterLast = true;
                this.close();
                return false;
            }
            case 100: {
                ++this.row;
                return true;
            }
            case 21: {
                throw new SQLException("JDBC internal consistency error");
            }
        }
        throw this.db.ex();
    }

    public int getType() throws SQLException {
        return 1003;
    }

    public int getFetchSize() throws SQLException {
        return this.limitRows;
    }

    public void setFetchSize(int n) throws SQLException {
        if (0 > n || this.maxRows != 0 && n > this.maxRows) {
            throw new SQLException("fetch size " + n + " out of bounds " + this.maxRows);
        }
        this.limitRows = n;
    }

    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return 1000;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.checkOpen();
        if (n != 1000) {
            throw new SQLException("only FETCH_FORWARD direction supported");
        }
    }

    public boolean isAfterLast() throws SQLException {
        return this.isAfterLast;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.row == 0;
    }

    public boolean isFirst() throws SQLException {
        return this.row == 1;
    }

    public boolean isLast() throws SQLException {
        throw new SQLException("function not yet implemented for SQLite");
    }

    void clearRS() throws SQLException {
        this.cols = null;
        this.isAfterLast = true;
        this.limitRows = 0;
        this.row = 1;
        this.lastCol = -1;
    }

    protected void finalize() throws SQLException {
        this.clearRS();
    }

    public int getRow() throws SQLException {
        return this.row;
    }

    public boolean wasNull() throws SQLException {
        return this.db.column_type(this.pointer, this.markCol(this.lastCol)) == 5;
    }

    public boolean getBoolean(int n) throws SQLException {
        return this.getInt(n) != 0;
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(int n) throws SQLException {
        return (byte)this.getInt(n);
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public byte[] getBytes(int n) throws SQLException {
        return this.db.column_blob(this.pointer, this.markCol(n));
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(int n) throws SQLException {
        return new Date(this.db.column_long(this.pointer, this.markCol(n)));
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        throw new SQLException("NYI");
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string), Calendar.getInstance());
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public double getDouble(int n) throws SQLException {
        return this.db.column_double(this.pointer, this.markCol(n));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public float getFloat(int n) throws SQLException {
        return (float)this.db.column_double(this.pointer, this.markCol(n));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public int getInt(int n) throws SQLException {
        return this.db.column_int(this.pointer, this.markCol(n));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(int n) throws SQLException {
        return this.db.column_long(this.pointer, this.markCol(n));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public short getShort(int n) throws SQLException {
        return (short)this.getInt(n);
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public String getString(int n) throws SQLException {
        return this.db.column_text(this.pointer, this.markCol(n));
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public Time getTime(int n) throws SQLException {
        return new Time(this.db.column_long(this.pointer, this.markCol(n)));
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        throw new SQLException("NYI");
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return new Timestamp(this.db.column_long(this.pointer, this.markCol(n)));
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        throw new SQLException("NYI");
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string), Calendar.getInstance());
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public Object getObject(int n) throws SQLException {
        switch (this.db.column_type(this.pointer, this.checkCol(n))) {
            case 1: {
                return new Integer(this.getInt(n));
            }
            case 2: {
                return new Double(this.getDouble(n));
            }
            case 4: {
                return this.getBytes(n);
            }
            case 5: {
                return null;
            }
        }
        return this.getString(n);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public String getCatalogName(int n) throws SQLException {
        return this.db.column_table_name(this.pointer, this.checkCol(n));
    }

    public String getColumnClassName(int n) throws SQLException {
        this.checkCol(n);
        throw new SQLException("NYI");
    }

    public int getColumnCount() throws SQLException {
        this.checkCol(1);
        return this.colsMeta.length;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        return Integer.MAX_VALUE;
    }

    public String getColumnLabel(int n) throws SQLException {
        return this.getColumnName(n);
    }

    public String getColumnName(int n) throws SQLException {
        return this.db.column_name(this.pointer, this.checkCol(n));
    }

    public int getColumnType(int n) throws SQLException {
        switch (this.db.column_type(this.pointer, this.checkCol(n))) {
            case 1: {
                return 4;
            }
            case 2: {
                return 6;
            }
            case 4: {
                return 2004;
            }
            case 5: {
                return 0;
            }
        }
        return 12;
    }

    public String getColumnTypeName(int n) throws SQLException {
        return this.db.column_decltype(this.pointer, this.checkCol(n));
    }

    public int getPrecision(int n) throws SQLException {
        return 0;
    }

    public int getScale(int n) throws SQLException {
        return 0;
    }

    public String getSchemaName(int n) throws SQLException {
        throw new SQLException("NYI");
    }

    public String getTableName(int n) throws SQLException {
        return this.db.column_table_name(this.pointer, this.checkCol(n));
    }

    public int isNullable(int n) throws SQLException {
        this.checkMeta();
        return this.meta[this.checkCol(n)][1] ? 0 : 1;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        this.checkMeta();
        return this.meta[this.checkCol(n)][2];
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        return true;
    }

    public boolean isCurrency(int n) throws SQLException {
        return false;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return true;
    }

    public boolean isReadOnly(int n) throws SQLException {
        return false;
    }

    public boolean isSearchable(int n) throws SQLException {
        return true;
    }

    public boolean isSigned(int n) throws SQLException {
        return false;
    }

    public boolean isWritable(int n) throws SQLException {
        return true;
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        return 1007;
    }

    public int getResultSetHoldability() throws SQLException {
        this.checkOpen();
        return 2;
    }

    public int getResultSetType() throws SQLException {
        this.checkOpen();
        return 1003;
    }

    public String getCursorName() throws SQLException {
        return null;
    }

    public void setCursorName(String string) {
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public Connection getConnection() throws SQLException {
        this.checkOpen();
        return this.conn;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return this;
    }

    public void cancel() throws SQLException {
        this.checkExec();
        this.db.interrupt();
    }

    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        return this.conn.getTimeout();
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.checkOpen();
        if (n < 0) {
            throw new SQLException("query timeout must be >= 0");
        }
        this.conn.setTimeout(1000 * n);
    }

    public int getMaxRows() throws SQLException {
        this.checkOpen();
        return this.maxRows;
    }

    public void setMaxRows(int n) throws SQLException {
        this.checkOpen();
        if (n < 0) {
            throw new SQLException("max row count must be >= 0");
        }
        this.maxRows = n;
    }

    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("max field size " + n + " cannot be negative");
        }
    }

    public ResultSet getResultSet() throws SQLException {
        this.checkExec();
        if (this.isRS()) {
            throw new SQLException("ResultSet already requested");
        }
        if (this.db.column_count(this.pointer) == 0) {
            throw new SQLException("no ResultSet available");
        }
        if (this.colsMeta == null) {
            this.colsMeta = this.db.column_names(this.pointer);
        }
        this.cols = this.colsMeta;
        boolean bl = this.isAfterLast = !this.resultsWaiting;
        if (this.resultsWaiting) {
            this.resultsWaiting = false;
        }
        return this;
    }

    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(0);
    }

    public boolean getMoreResults(int n) throws SQLException {
        this.checkOpen();
        if (this.isRS()) {
            this.close();
        }
        return false;
    }
}

